/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.validator;

import com.ontotext.graphql.parser.SelectionBuilder;
import com.ontotext.models.ActionFilter;
import com.ontotext.models.CompositeActionFilter;
import com.ontotext.models.Constraint;
import com.ontotext.models.Constraints;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Rbac;
import com.ontotext.models.Role;
import com.ontotext.models.Selectable;
import com.ontotext.models.SelectableConstraints;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.models.extensions.Severity;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.security.RbacRestrictions;
import com.ontotext.models.security.RbacResult;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.util.RbacUtils;
import com.ontotext.rbac.util.RolesProviderUtil;
import com.ontotext.rbac.validator.RbacConstraintsValidationContext;
import com.ontotext.soaas.plugin.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RbacConstraintsValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RbacConstraintsValidator.class);
    private static final String FILTER_APPLIED = "security.rbac.results.filter.applied";
    private static final String DELETE_FILTER_APPLIED = "security.rbac.deletion.filter.applied";
    private static final Set<String> SYSTEM_PROPS = Set.of("affected_count", "affected_objects", "__typename");
    private static final String LITERAL = "Literal";
    protected ConfigurationResolver configurationResolver;

    public boolean isEnabled(ValidatorOptions options) {
        return options.isEnabled(RbacConstraintsValidator.class);
    }

    public boolean isSecurityNotEnabled() {
        return this.configurationResolver == null || !this.configurationResolver.isSecurityEnabled();
    }

    protected boolean isMutation(Operation baseOperation) {
        return baseOperation.getOperationType().isMutation();
    }

    protected RbacConstraintsValidationContext buildValidationContext(Operation operation, ValidationContext validationContext) {
        return new RbacConstraintsValidationContext(operation, validationContext.getSomlSchema(), validationContext.getUserRoles(), validationContext.getLoginUserRoles(), RbacConstraintsValidationContext.Phase.VALIDATE);
    }

    protected RbacConstraintsValidationContext buildPostProcessingContext(Operation operation, SecurityContext securityContext) {
        return new RbacConstraintsValidationContext(operation, operation.getSchema(), this.getEffectiveUserRoles(operation.getSchema().getRbac(), securityContext), RolesProviderUtil.getRoles(securityContext), RbacConstraintsValidationContext.Phase.POST_PROCESS);
    }

    private Set<com.ontotext.models.security.Role> getEffectiveUserRoles(Rbac rbac, SecurityContext securityContext) {
        List<Role> roles = RolesProviderUtil.getEffectiveUserRoles(securityContext, rbac.getRoles());
        return roles.stream().map(role -> new com.ontotext.models.security.Role(role.getName())).collect(Collectors.toSet());
    }

    protected boolean isReturnTypeAccessible(RbacConstraintsValidationContext context, Shape returnType, Collection<SourceLocation> locations) {
        RbacResult result = RbacConstraintsValidator.isOperationPermitted(context, returnType);
        if (!result.isCalculated() && (returnType.isAbstract() || returnType.isUnion())) {
            context.addMessage(Severity.WARN, "security.rbac.not.calculated", locations, this.getGraphqlName(returnType));
            return false;
        }
        if (!result.isAllowed()) {
            context.addMessage(Severity.ERROR, "security.rbac.unauthorized.access", locations, context.getOperationType().name().toLowerCase(), this.getGraphqlName(returnType));
            return false;
        }
        if (context.isValidationPhase() && result.isConstrained() && this.shouldAddConstraintsOnRootLevel(context)) {
            Set<Constraint> constraints = result.getConstraints();
            constraints = RbacUtils.replaceContextVariables(constraints, context);
            context.getOperation().addTypeConstraints(constraints);
            if (result.isFilterOnlyConstrainedAgainst(returnType)) {
                this.raiseWarningForFilterConstrainedResult(context, locations, constraints, returnType, null, this.getTemplateForRootLevelFilter(context));
            } else {
                context.addMessage(Severity.WARN, "security.rbac.type.constrained", locations, this.getGraphqlName(returnType), this.getConstraintsAsMessageArguments(constraints), context.getAuthorizationsAsString());
            }
        }
        return true;
    }

    private String getTemplateForRootLevelFilter(RbacConstraintsValidationContext context) {
        String template = context.getOperationType() == OperationType.DELETE ? DELETE_FILTER_APPLIED : FILTER_APPLIED;
        return template;
    }

    private boolean shouldAddConstraintsOnRootLevel(RbacConstraintsValidationContext context) {
        OperationType operationType = context.getOperationType();
        return operationType == OperationType.QUERY || operationType == OperationType.DELETE;
    }

    private static RbacResult isOperationPermitted(RbacConstraintsValidationContext context, Shape shape) {
        RbacRestrictions restrictions = context.getRestrictions();
        Set<com.ontotext.models.security.Role> userRoles = context.getRoles();
        return switch (context.getOperationType()) {
            case OperationType.QUERY -> restrictions.canRead(shape, userRoles);
            case OperationType.CREATE, OperationType.UPDATE -> restrictions.canWrite(shape, userRoles);
            case OperationType.DELETE -> restrictions.canDelete(shape, userRoles);
            default -> {
                LOGGER.warn("Forbidding unhandled operation type {}", (Object)context.getOperationType());
                yield RbacResult.forbidden();
            }
        };
    }

    protected void addConstraintsOrWarningsToQuerySelections(RbacConstraintsValidationContext context, List<Selection> selections) {
        for (Selection selection : new ArrayList<Selection>(selections)) {
            if (SYSTEM_PROPS.contains(selection.getName())) continue;
            if (this.isComplexSelection(selection)) {
                this.checkViolationsOfComplexSelections(context, selection);
                continue;
            }
            if (selection.isCountSelection()) {
                this.checkViolationsOfCountSelections(context, selection);
                continue;
            }
            this.addConstraintsOrWarningsToSelection(context, selection);
        }
        this.looseParentConstraintsIfNeeded(selections);
    }

    private void checkViolationsOfComplexSelections(RbacConstraintsValidationContext context, Selection selection) {
        if (selection.getParent() instanceof Mutation) {
            this.addConstraintsOrWarningsToQuerySelections(context, selection.getSelections());
        } else {
            Shape nestedShape = RbacConstraintsValidator.getNestedShape(context, selection.getType());
            if (this.addConstraintsOrWarningsToSelection(context, selection) && this.addConstraintsOrWarningsToSubSelection(context, nestedShape, selection)) {
                this.addConstraintsOrWarningsToQuerySelections(context, selection.getSelections());
            }
        }
    }

    private void checkViolationsOfCountSelections(RbacConstraintsValidationContext context, Selection selection) {
        Shape countedShape = selection.getCountedSelection().flatMap(Selectable::getShapeType).orElse(null);
        Optional collectionSelection = selection.getCountedSelection();
        Selectable countedSelection = collectionSelection.isPresent() ? (Selectable)selection.getParent().getSelections().stream().filter(Selectable.byName((String)((Selectable)collectionSelection.get()).getName())).filter(Selectable::isRequestedByUser).findFirst().or(() -> collectionSelection).orElse(null) : (Selectable)collectionSelection.orElse(null);
        if (countedShape != null && countedSelection != null) {
            this.addConstraintsOrWarningsToSelection(context, (Selection)countedSelection);
            this.addConstraintsOrWarningsToSubSelection(context, countedShape, (Selection)countedSelection);
            if (countedSelection.isIgnored()) {
                selection.setIgnored(true);
                context.addMessage(Severity.WARN, "security.rbac.field.query.restricted", Collections.singleton(selection.getLocation()), selection.getName(), this.getGraphqlName(selection.getDefinedInType()), context.getAuthorizationsAsString());
            }
        }
    }

    private void looseParentConstraintsIfNeeded(List<Selection> selections) {
        if (selections.isEmpty() || selections.stream().noneMatch(Selectable::hasConstraints)) {
            return;
        }
        Selectable parent = selections.get(0).getParent();
        SelectableConstraints parentConstraints = parent.getConstraints();
        if (parentConstraints == null || !parentConstraints.hasTypeConstraints()) {
            return;
        }
        Set typeConstraints = parentConstraints.getTypeConstraints();
        selections.stream().filter(selection -> !selection.hasConstraints() || !selection.getConstraints().hasFragmentConstraints()).forEach(selection -> selection.addFragmentConstraints((Collection)typeConstraints));
        List<Selection> selectionsWithFragmentConstraints = selections.stream().filter(selection -> selection.hasConstraints() && selection.getConstraints().hasFragmentConstraints()).collect(Collectors.toList());
        this.mergeParentAndChildrenConstraints(parent, selectionsWithFragmentConstraints);
    }

    private void mergeParentAndChildrenConstraints(Selectable parent, List<Selection> selectionsWithFragmentConstraints) {
        Set parentTypeConstraints = parent.getConstraints().getTypeConstraints();
        selectionsWithFragmentConstraints.forEach(selection -> {
            Set childFragmentsConstraints = selection.getConstraints().getFragmentConstraints();
            for (Constraint childFragmentsConstraint : childFragmentsConstraints) {
                Set parentConstForSameShape = parentTypeConstraints.stream().filter(constraint -> constraint.getShapeId().equals(childFragmentsConstraint.getShapeId())).collect(Collectors.toSet());
                if (!parentConstForSameShape.isEmpty() && this.isNonNegativeCompositeFilterConstraint(childFragmentsConstraint)) {
                    Constraint concreteConstr = parentConstForSameShape.stream().filter(constr -> constr.getFilter() instanceof CompositeActionFilter).findAny().orElse(null);
                    if (concreteConstr != null) {
                        parentTypeConstraints.remove(concreteConstr);
                        parentTypeConstraints.add(new Constraint(concreteConstr.getShapeId(), (ActionFilter)((CompositeActionFilter)concreteConstr.getFilter()).merge((CompositeActionFilter)childFragmentsConstraint.getFilter())));
                        continue;
                    }
                    parentTypeConstraints.add(childFragmentsConstraint);
                    continue;
                }
                parentTypeConstraints.add(childFragmentsConstraint);
            }
        });
    }

    private boolean isNonNegativeCompositeFilterConstraint(Constraint childFragmentsConstraint) {
        return childFragmentsConstraint.getFilter() instanceof CompositeActionFilter && !((CompositeActionFilter)childFragmentsConstraint.getFilter()).hasNegatives();
    }

    private boolean isComplexSelection(Selection selection) {
        return selection.isComplexType() && !LITERAL.equals(selection.getType());
    }

    private boolean addConstraintsOrWarningsToSubSelection(RbacConstraintsValidationContext context, Shape shape, Selection selection) {
        RbacResult result = context.getRestrictions().canRead(shape, context.getRoles());
        if (!result.isAllowed()) {
            selection.setIgnored(true);
            this.ifRequestedByUser(selection, current -> context.addMessage(Severity.WARN, "security.rbac.field.query.nested.restricted", Collections.singleton(current.getLocation()), current.getName(), this.getGraphqlName(shape), context.getAuthorizationsAsString()));
            return false;
        }
        if (result.isConstrained()) {
            Set<Constraint> constraints = RbacUtils.replaceContextVariables(result.getConstraints(), context);
            selection.addTypeConstraints(constraints);
            if (result.isFilterOnlyConstrainedAgainst(shape)) {
                this.ifRequestedByUser(selection, current -> this.raiseWarningForFilterConstrainedResult(context, Collections.singleton(current.getLocation()), constraints, shape, null, FILTER_APPLIED));
            } else {
                this.ifRequestedByUser(selection, current -> context.addMessage(Severity.WARN, "security.rbac.field.type.constrained", Collections.singleton(current.getLocation()), current.getName(), current.getType(), this.getConstraintsAsMessageArguments(constraints), context.getAuthorizationsAsString()));
            }
        }
        return true;
    }

    private boolean addConstraintsOrWarningsToSelection(RbacConstraintsValidationContext context, Selection selection) {
        Shape shape = selection.getDefinedInType();
        PropertyShape property = RbacConstraintsValidator.resolveProperty(shape, selection.getName(), context.getSchema());
        Set<com.ontotext.models.security.Role> roles = context.getRoles();
        RbacResult result = context.getRestrictions().canRead(shape, property.getName(), roles);
        if (!result.isAllowed()) {
            if (context.isPostProcessPhase() && selection.hasDomainConstraints() && this.checkSelectionDomainConstraints(context, selection, property, roles)) {
                return true;
            }
            selection.setIgnored(true);
            this.ifRequestedByUser(selection, current -> context.addMessage(Severity.WARN, "security.rbac.field.query.restricted", Collections.singleton(current.getLocation()), property.getName(), this.getGraphqlName(current.getDefinedInType()), context.getAuthorizationsAsString()));
            return false;
        }
        if (result.isConstrained()) {
            this.handleConstraintSelection(context, selection, shape, result);
        }
        return true;
    }

    private boolean checkSelectionDomainConstraints(RbacConstraintsValidationContext context, Selection selection, PropertyShape property, Set<com.ontotext.models.security.Role> roles) {
        List<Pair<Shape, RbacResult>> allowedConstraintTypes = this.resolveAllowedDomainConstraintPermissions(context, selection, property, roles);
        if (allowedConstraintTypes.isEmpty()) {
            return false;
        }
        Map<Boolean, List<Pair<Shape, RbacResult>>> byConstraints = allowedConstraintTypes.stream().collect(Collectors.groupingBy(pair -> ((RbacResult)pair.getValue()).isConstrained()));
        if (byConstraints.containsKey(Boolean.TRUE)) {
            this.restrictDomainConstraintsWithFilters(selection, context, byConstraints);
        }
        if (byConstraints.containsKey(Boolean.FALSE)) {
            this.restrictDomainConstraintsTo(selection, byConstraints);
        }
        return true;
    }

    @NotNull
    private List<Pair<Shape, RbacResult>> resolveAllowedDomainConstraintPermissions(RbacConstraintsValidationContext context, Selection selection, PropertyShape property, Set<com.ontotext.models.security.Role> roles) {
        String id = selection.getDefinedInType().getId();
        return selection.getDomainConstraints().stream().filter(constraint -> !constraint.getId().equals(id)).flatMap(constraint -> {
            RbacResult rbacResult = context.getRestrictions().canRead(constraint, property.getName(), roles);
            return rbacResult.isAllowed() ? Stream.of(Pair.of((Object)constraint, (Object)rbacResult)) : Stream.empty();
        }).collect(Collectors.toList());
    }

    private void restrictDomainConstraintsWithFilters(Selection selection, RbacConstraintsValidationContext context, Map<Boolean, List<Pair<Shape, RbacResult>>> byConstraints) {
        Collection<List<Pair>> byUniqueConstraint = byConstraints.get(Boolean.TRUE).stream().collect(Collectors.groupingBy(pair -> ((RbacResult)pair.getValue()).getConstraints().toString())).values();
        for (List<Pair> commonConstraints : byUniqueConstraint) {
            List<Shape> constraintTypes = commonConstraints.stream().map(Pair::getKey).collect(Collectors.toList());
            this.buildConstraintSelection(context, selection, constraintTypes);
        }
    }

    private void buildConstraintSelection(RbacConstraintsValidationContext context, Selection selection, List<Shape> constraintTypes) {
        SelectionBuilder builder = new SelectionBuilder(context.getSchema());
        Selection newSelection = (Selection)builder.addSelection(selection.getName(), constraintTypes.get(0).getId(), selection.getParent()).get();
        newSelection.setArguments(selection.getArguments());
        newSelection.setRangeCheck(selection.isRangeCheck());
        newSelection.setAlias(selection.getAlias());
        newSelection.setDomainConstraints(constraintTypes);
        selection.getSelections().stream().map(Selection::deepCopy).forEach(newSelection.getSelections()::add);
    }

    private void handleConstraintSelection(RbacConstraintsValidationContext context, Selection selection, Shape shape, RbacResult result) {
        Set<Constraint> constraints = RbacUtils.replaceContextVariables(result.getConstraints(), context);
        if (selection.hasDomainConstraints() && (!shape.isAbstract() || shape.isAbstract() && shape.getSubTypes().size() == selection.getDomainConstraints().size())) {
            PropertyShape property = RbacConstraintsValidator.resolveProperty(shape, selection.getName(), context.getSchema());
            this.resolveAllowedDomainConstraintPermissions(context, selection, property, context.getRoles()).stream().map(pair -> ((RbacResult)pair.getValue()).getConstraints()).map(constr -> RbacUtils.replaceContextVariables(constr, context)).forEach(constraints::addAll);
        }
        if (this.parentSelectionHasSameConstraints(selection, constraints)) {
            return;
        }
        selection.addFragmentConstraints(constraints);
        if (result.isFilterOnlyConstrainedAgainst(shape)) {
            this.ifRequestedByUser(selection, current -> this.raiseWarningForFilterConstrainedResult(context, Collections.singleton(current.getLocation()), constraints, shape, current.getName(), FILTER_APPLIED));
        } else {
            this.ifRequestedByUser(selection, current -> context.addMessage(Severity.WARN, "security.rbac.field.constrained", Collections.singleton(current.getLocation()), current.getName(), current.getDefinedIn(), this.getConstraintsAsMessageArguments(constraints), context.getAuthorizationsAsString()));
        }
    }

    private void restrictDomainConstraintsTo(Selection selection, Map<Boolean, List<Pair<Shape, RbacResult>>> byConstraints) {
        List allowedTypes = byConstraints.get(Boolean.FALSE).stream().map(Pair::getKey).collect(Collectors.toList());
        if (!allowedTypes.isEmpty()) {
            selection.setDefinedInType((Shape)allowedTypes.get(0));
            selection.getDomainConstraints().clear();
            selection.getDomainConstraints().addAll(allowedTypes);
        }
    }

    void ifRequestedByUser(Selection selection, Consumer<Selection> consumer) {
        if (selection.isRequestedByUser()) {
            consumer.accept(selection);
        }
    }

    void raiseWarningForFilterConstrainedResult(RbacConstraintsValidationContext context, Collection<SourceLocation> locations, Set<Constraint> constraints, Shape returnType, String prop, String template) {
        Object resource = returnType.getId();
        if (prop != null) {
            resource = (String)resource + "." + prop;
        }
        Object constraintsAsString = Constraints.asUserMessage(constraints, (Shape)returnType);
        context.addMessage(Severity.WARN, template, locations, resource, constraintsAsString);
    }

    private List<String> getConstraintsAsMessageArguments(Set<Constraint> constraints) {
        return constraints.stream().map(Constraint::toMessage).sorted().collect(Collectors.toList());
    }

    private boolean parentSelectionHasSameConstraints(Selection selection, Set<Constraint> constraints) {
        return selection.getParent().hasConstraints() && constraints.equals(selection.getParent().getConstraints().getTypeConstraints());
    }

    private static Shape getNestedShape(RbacConstraintsValidationContext context, String typeName) {
        SomlSchema schema = context.getSchema();
        String shapeName = schema.getPrefixes().nameToShortIri(typeName);
        return (Shape)schema.getObjects().get((Object)shapeName);
    }

    protected String getGraphqlName(Shape shape) {
        return RbacConstraintsValidator.capitalize(shape.asGraphQl());
    }

    private static String capitalize(String name) {
        String[] parts = name.split("_", 2);
        if (parts.length == 2) {
            return parts[0] + "_" + StringUtils.capitalize((String)name);
        }
        return StringUtils.capitalize((String)name);
    }

    static PropertyShape resolveProperty(Shape shape, String propertyName, SomlSchema schema) {
        return shape.getProperty(propertyName).orElseGet(() -> (PropertyShape)shape.getProperty(schema.getPrefixes().nameToShortIri(propertyName)).orElseThrow(IllegalArgumentException::new));
    }

    @Inject
    public void setConfigurationResolver(ConfigurationResolver configurationResolver) {
        this.configurationResolver = configurationResolver;
    }
}

