/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.validator;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.extensions.Severity;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.security.RbacRestrictions;
import com.ontotext.models.security.Role;
import com.ontotext.rbac.jwt.UserWithClaims;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class RbacConstraintsValidationContext {
    private final Operation operation;
    private final SomlSchema schema;
    private final RbacRestrictions restrictions;
    private final Set<Role> authorizations;
    private final Map<Pair<String, Severity>, LinkedHashSet<SourceLocation>> responseMessages;
    private final Set<Role> roles;
    private final String userName;
    private final Phase phase;

    public RbacConstraintsValidationContext(Operation operation, SomlSchema schema, Set<Role> roles, Set<Role> authorizations, Phase phase) {
        this.operation = operation;
        this.schema = schema;
        this.roles = roles;
        this.restrictions = schema.getRbac().getRestrictions();
        this.authorizations = authorizations;
        this.phase = phase;
        this.responseMessages = new LinkedHashMap<Pair<String, Severity>, LinkedHashSet<SourceLocation>>();
        this.userName = this.extractUsername();
    }

    private String extractUsername() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext != null && securityContext.getAuthentication() != null) {
            return securityContext.getAuthentication().getName();
        }
        return "";
    }

    public void addMessage(Severity severity, String template, Collection<SourceLocation> locations, Object ... args) {
        String message = ErrorMessages.get((String)template, (Object[])args);
        this.responseMessages.computeIfAbsent((Pair<String, Severity>)Pair.of((Object)message, (Object)severity), key -> new LinkedHashSet()).addAll(locations);
    }

    public OperationResponse getResponse() {
        if (this.responseMessages.isEmpty()) {
            return OperationResponse.EMPTY;
        }
        OperationResponse response = new OperationResponse();
        this.responseMessages.forEach((key, value) -> response.add((OperationResponse.OperationMessage)new QueryValidationMessage((Severity)key.getRight(), (String)key.getLeft(), (Collection)value)));
        return response;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public OperationType getOperationType() {
        return this.operation.getOperationType();
    }

    public String getUserName() {
        return this.userName;
    }

    public RbacRestrictions getRestrictions() {
        return this.restrictions;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public Set<Role> getAuthorizations() {
        return this.authorizations;
    }

    public String getAuthorizationsAsString() {
        return Arrays.toString(this.authorizations.stream().map(Role::getName).toArray());
    }

    public SomlSchema getSchema() {
        return this.schema;
    }

    public Object resolveUserClaim(String claimKey) {
        return UserWithClaims.resolveClaimValue(claimKey, Object.class);
    }

    public Collection<String> resolveUserClaims(String claimKey) {
        return UserWithClaims.resolveClaimValues(claimKey);
    }

    public boolean isPostProcessPhase() {
        return this.phase == Phase.POST_PROCESS;
    }

    public boolean isValidationPhase() {
        return this.phase == Phase.VALIDATE;
    }

    public static enum Phase {
        POST_PROCESS,
        VALIDATE;

    }
}

