/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.util;

import com.ontotext.models.Role;
import com.ontotext.models.Roles;
import com.ontotext.rbac.DefaultRolesProvider;
import com.ontotext.rbac.RolesProvider;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RolesProviderUtil {
    private static RolesProvider instance;

    private RolesProviderUtil() {
    }

    private static RolesProvider loadImplementation() {
        List implementations = PluginsManager.loadPlugins(RolesProvider.class);
        return implementations.isEmpty() ? new DefaultRolesProvider() : (RolesProvider)implementations.getFirst();
    }

    public static Set<com.ontotext.models.security.Role> getRoles(SecurityContext context) {
        return context.getAuthorities().map(com.ontotext.models.security.Role::new).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static List<Role> getEffectiveUserRoles(SecurityContext context, Roles rbacRoles) {
        if (Objects.isNull(instance)) {
            instance = RolesProviderUtil.loadImplementation();
        }
        return instance.getEffectiveRoles(context, rbacRoles);
    }
}

