/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.util;

import com.ontotext.graphql.parser.GraphQlQueryParser;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.DefaultArgumentConverter;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.models.RoleAction;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.Query;
import com.ontotext.platform.SomlToGraphQlSchemaConverter;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.validator.RbacSchemaValidator;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.sparql.Rdf4jInputValueConverter;
import graphql.GraphqlErrorBuilder;
import graphql.schema.GraphQLSchema;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RbacFilterToParsedQueryHelper {
    private static final String FILTER_TEMPLATE = "check_filter_template.graphql";
    private final SomlSchema somlSchema;
    private GraphQlQueryParser queryParser;
    private boolean validSchema = true;
    private static final Pattern CTX_CLAIMS_PATTERNS = Pattern.compile("(\\$\\{ctx\\.(?:claims\\.)?([\\w+-]+)})");
    private static String queryTemplate;

    public RbacFilterToParsedQueryHelper(SomlSchema somlSchema) {
        this.somlSchema = somlSchema;
    }

    public boolean isHelperReadyToParse() {
        return this.getParser() != null;
    }

    public Query parseRbacFilter(RoleAction action) {
        GraphQlQueryParser parser = this.getParser();
        if (parser == null) {
            return null;
        }
        try {
            String filterGraphqlQuery = this.parseFilterTemplateQuery(action.getObject(), action.getFilter());
            return (Query)parser.parse((Object)this.processCtxPropertiesInWhereClause(filterGraphqlQuery), null, null, SecurityContext.empty()).getFirst();
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new InvalidOperationException("Query parsing error: " + ex.getMessage(), Collections.singletonList(GraphqlErrorBuilder.newError().message("Query parsing error: " + ex.getMessage(), new Object[0]).build()));
        }
    }

    private GraphQlQueryParser getParser() {
        if (this.queryParser == null && this.validSchema) {
            this.queryParser = this.prepareQueryParser(this.somlSchema);
        }
        return this.queryParser;
    }

    private String processCtxPropertiesInWhereClause(String query) {
        return CTX_CLAIMS_PATTERNS.matcher(query).replaceAll("\"$1\"");
    }

    private String parseFilterTemplateQuery(String object, String filter) throws IOException {
        return RbacFilterToParsedQueryHelper.getQueryTemplate().replaceFirst("<obj>", this.resolveQueryName(object)).replace("<where>", filter);
    }

    private static String getQueryTemplate() throws IOException {
        if (queryTemplate == null) {
            try (InputStream template = RbacSchemaValidator.class.getClassLoader().getResourceAsStream(FILTER_TEMPLATE);){
                queryTemplate = IOUtils.toString((InputStream)Objects.requireNonNull(template, "Failed to load template file check_filter_template.graphql"), (Charset)StandardCharsets.UTF_8);
            }
        }
        return queryTemplate;
    }

    private String resolveQueryName(String object) {
        object = StringManipulation.toGraphQlModelName((String)object);
        return this.somlSchema.getConfig().getQueryName(StringUtils.uncapitalize((String)object));
    }

    private GraphQlQueryParser prepareQueryParser(SomlSchema somlSchema) {
        SomlToGraphQlSchemaConverter schemaConverter = new SomlToGraphQlSchemaConverter();
        try {
            GraphQLSchema graphQlSchema = (GraphQLSchema)schemaConverter.convert(somlSchema);
            return new GraphQlQueryParser(graphQlSchema, somlSchema, (ArgumentConverter)new DefaultArgumentConverter((InputValueConverter)new Rdf4jInputValueConverter()));
        }
        catch (Exception re) {
            this.validSchema = false;
            return null;
        }
    }
}

