/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.soml.access;

import com.ontotext.models.Rbac;
import com.ontotext.models.Role;
import com.ontotext.models.RoleAction;
import com.ontotext.models.RoleActionType;
import com.ontotext.models.Roles;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.exceptions.NoPermissionsException;
import com.ontotext.rbac.util.RolesProviderUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SomlAccessCalculator {
    private static final String WILDCARD = "*";

    private SomlAccessCalculator() {
    }

    public static void verifyUserPermissions(String id, RoleActionType operation, Rbac rbac, SecurityContext securityContext) {
        if (!SomlAccessCalculator.hasPermissions(id, operation, rbac, securityContext)) {
            throw NoPermissionsException.operationNotAllowed(securityContext);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasPermissions(String schemaId, RoleActionType executedAction, Rbac rbac, SecurityContext securityContext) {
        List<Role> userRbacRoles = SomlAccessCalculator.getUserRbacRoles(rbac.getRoles(), securityContext);
        if (userRbacRoles.isEmpty()) {
            return false;
        }
        List<Permissions> permissions = SomlAccessCalculator.calculatePerRole(schemaId, executedAction, userRbacRoles);
        if (permissions.isEmpty()) return false;
        if (!permissions.stream().allMatch(Permissions.GRANTED::equals)) return false;
        return true;
    }

    private static String normalizeId(String id) {
        return id != null ? id.replaceFirst("^/soml/", "") : id;
    }

    private static List<Role> getUserRbacRoles(Roles rbacRoles, SecurityContext securityContext) {
        return RolesProviderUtil.getEffectiveUserRoles(securityContext, rbacRoles);
    }

    private static List<Permissions> calculatePerRole(String schemaId, RoleActionType executedAction, List<Role> userRbacRoles) {
        String id = SomlAccessCalculator.normalizeId(schemaId);
        return userRbacRoles.stream().map(role -> {
            if (SomlAccessCalculator.calculate(id, role.getNotActions(), executedAction)) {
                return Permissions.DENIED;
            }
            if (SomlAccessCalculator.calculate(id, role.getActions(), executedAction)) {
                return Permissions.GRANTED;
            }
            return Permissions.UNDEFINED;
        }).filter(Permissions.IS_DEFINED).collect(Collectors.toList());
    }

    private static boolean calculate(String id, List<RoleAction> actions, RoleActionType executedAction) {
        return SomlAccessCalculator.getMatchingDefinitions(id, actions).stream().map(RoleAction::getActionType).anyMatch(SomlAccessCalculator.matchesType(executedAction));
    }

    private static Predicate<RoleActionType> matchesType(RoleActionType executedAction) {
        return type -> RoleActionType.ALL.equals(type) || executedAction.equals(type);
    }

    private static List<RoleAction> getMatchingDefinitions(String id, List<RoleAction> roleActions) {
        return roleActions.stream().filter(action -> {
            String idFilter = SomlAccessCalculator.getFilter(action);
            return WILDCARD.equals(idFilter) || idFilter.equals(id) || id.matches(SomlAccessCalculator.toExpression(idFilter));
        }).collect(Collectors.toList());
    }

    private static String getFilter(RoleAction action) {
        return Objects.requireNonNull(action.getObject(), "Received RoleAction " + String.valueOf(action) + " with no filter");
    }

    private static String toExpression(String filter) {
        return "^" + filter.replace(WILDCARD, ".*") + "$";
    }

    private static enum Permissions {
        GRANTED,
        DENIED,
        UNDEFINED;

        private static final Predicate<Permissions> IS_DEFINED;

        static {
            IS_DEFINED = permissions -> !UNDEFINED.equals(permissions);
        }
    }
}

