/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.models.extensions;

import com.ontotext.models.RoleAction;
import com.ontotext.models.RoleActionType;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.rbac.models.extensions.RoleActionsParserBase;

@Order(value=100)
public class RoleActionsParser
extends RoleActionsParserBase {
    private static final int CORRECT_ACTION_SYNTAX_LENGTH = 3;
    private static final int CORRECT_ACTION_FILTER_SYNTAX_LENGTH = 4;

    public boolean canHandle(SomlSchema somlSchema) {
        return !"/soml/soml-rbac".equals(somlSchema.getId());
    }

    @Override
    protected boolean isSyntaxValid(String[] split) {
        return split.length == 3 || split.length == 4;
    }

    @Override
    protected void initRoleAction(RoleAction action, String[] split) {
        action.setObject(split[0].trim());
        action.setProperty(split[1].trim());
        String actionType = split[2].trim().toUpperCase();
        if ("*".equals(actionType)) {
            action.setActionType(RoleActionType.ALL);
        } else if (ACTION_TYPES.contains(actionType)) {
            action.setActionType(RoleActionType.valueOf((String)actionType));
        }
        if (split.length == 4) {
            action.setFilter(split[3].trim());
        }
    }
}

