/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.models.extensions;

import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Role;
import com.ontotext.models.RoleAction;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.security.RbacRestrictions;
import com.ontotext.rbac.util.RbacUtils;
import com.ontotext.soaas.plugin.Order;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Order(value=3300)
public class AssignRbacRestrictions
implements SchemaExtension {
    private static final String WILDCARD = "*";

    public boolean canHandle(SomlSchema schema) {
        return schema.getSpecialPrefixes().getVocabPrefix().isPresent();
    }

    public void postBaseSchemaMergeProcessing(SomlSchema somlSchema) {
        RbacRestrictions restrictions = somlSchema.getRbac().getRestrictions();
        somlSchema.getRbac().getRoles().values().forEach(this.roleConsumer(somlSchema, restrictions));
    }

    private Consumer<Role> roleConsumer(SomlSchema somlSchema, RbacRestrictions restrictions) {
        return role -> {
            if (role != null) {
                this.mapActions(role.getActions(), somlSchema, (shape, action) -> this.addAction(restrictions, (Shape)shape, (RoleAction)action));
                this.mapActions(role.getNotActions(), somlSchema, (shape, action) -> this.addNotAction(restrictions, (Shape)shape, (RoleAction)action));
            }
        };
    }

    private void mapActions(List<RoleAction> actions, SomlSchema somlSchema, BiConsumer<Shape, RoleAction> actionConsumer) {
        actions.stream().filter(this::isActionValid).forEach(action -> this.mapShapeActions((RoleAction)action, somlSchema, actionConsumer));
    }

    private boolean isActionValid(RoleAction action) {
        return StringUtils.isNotBlank((CharSequence)action.getObject()) && StringUtils.isNotBlank((CharSequence)action.getProperty()) && action.getActionType() != null;
    }

    private void mapShapeActions(RoleAction action, SomlSchema somlSchema, BiConsumer<Shape, RoleAction> actionConsumer) {
        Shapes shapes = somlSchema.getObjects();
        String objectFilter = action.getObject();
        RbacUtils.resolveShapes((Map<String, Shape>)shapes, objectFilter).forEach(shape -> actionConsumer.accept((Shape)shape, action));
    }

    private void addAction(RbacRestrictions restrictions, Shape shape, RoleAction action) {
        restrictions.addAction(shape, action);
        action.addRelatedShape(shape);
        this.mapPropertyActions(shape.getAllProperties(), action, (propertyShape, propertyAction) -> this.addPropertyAction(restrictions, shape, (PropertyShape)propertyShape, (RoleAction)propertyAction));
    }

    private void addNotAction(RbacRestrictions restrictions, Shape shape, RoleAction action) {
        if (WILDCARD.equals(action.getProperty())) {
            restrictions.addNotAction(shape, action);
        }
        action.addRelatedShape(shape);
        this.mapPropertyActions(shape.getAllProperties(), action, (propertyShape, propertyAction) -> this.addPropertyNotAction(restrictions, shape, (PropertyShape)propertyShape, (RoleAction)propertyAction));
    }

    private void mapPropertyActions(Properties properties, RoleAction action, BiConsumer<PropertyShape, RoleAction> actionConsumer) {
        if (properties == null) {
            return;
        }
        String propertyFilter = action.getProperty();
        if (WILDCARD.equals(propertyFilter)) {
            properties.values().forEach(property -> actionConsumer.accept((PropertyShape)property, action));
        } else if (properties.containsKey((Object)propertyFilter)) {
            actionConsumer.accept((PropertyShape)properties.get((Object)propertyFilter), action);
        } else {
            this.resolvePropertyShapes((Map<String, PropertyShape>)properties, propertyFilter).forEach(property -> actionConsumer.accept((PropertyShape)property, action));
        }
    }

    private void addPropertyAction(RbacRestrictions restrictions, Shape shape, PropertyShape propertyShape, RoleAction action) {
        restrictions.addAction(shape, propertyShape, action);
        action.addRelatedPropertyShape(propertyShape);
    }

    private void addPropertyNotAction(RbacRestrictions restrictions, Shape shape, PropertyShape propertyShape, RoleAction action) {
        restrictions.addNotAction(shape, propertyShape, action);
        action.addRelatedPropertyShape(propertyShape);
    }

    private List<PropertyShape> resolvePropertyShapes(Map<String, PropertyShape> propertyShapes, String shapeFilter) {
        return propertyShapes.values().stream().filter(shape -> shape.getName().matches(RbacUtils.toExpression(shapeFilter))).collect(Collectors.toList());
    }
}

