/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.jwt;

import com.ontotext.rbac.jwt.Jwt;
import com.ontotext.rbac.jwt.JwtClaimMapping;
import com.ontotext.rbac.jwt.RemoteJwkSigningKeyResolver;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.logging.Loggers;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class JwtProcessor {
    private static final String AUTHORIZATION_TYPE = "Bearer ";
    private static final int ALLOWED_SKEW_TIME = 180;
    private final String encodedSecret;
    private final JwtClaimMapping jwtClaims;
    private final JwtParser jwtParser;

    private JwtProcessor() {
        this.encodedSecret = null;
        this.jwtParser = null;
        this.jwtClaims = JwtClaimMapping.DEFAULTS;
    }

    private JwtProcessor(String secret, String jwksUri, JwtClaimMapping jwtClaimMappings) {
        this.encodedSecret = org.springframework.util.StringUtils.hasText((String)secret) ? secret : null;
        this.jwtParser = JwtProcessor.createParser(this.encodedSecret, jwksUri);
        this.jwtClaims = jwtClaimMappings == null ? JwtClaimMapping.DEFAULTS : jwtClaimMappings;
        this.logClaimMapping();
    }

    private void logClaimMapping() {
        Loggers.securityLogger().info("Configured security using the following claim mapping:");
        Loggers.securityLogger().info("username:    : {}", (Object)this.jwtClaims.getUsernameClaim());
        Loggers.securityLogger().info("roles:       : {}", (Object)this.jwtClaims.getRolesClaim());
        Loggers.securityLogger().info("email:       : {}", (Object)this.jwtClaims.getEmailClaim());
    }

    public Optional<Jwt> resolveToken(String authorizationHeader) {
        return this.getToken(authorizationHeader).map(token -> new Jwt(this.extractAllClaims((String)token), this.jwtClaims));
    }

    public Optional<String> getToken(String authorizationHeader) {
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader) && authorizationHeader.startsWith(AUTHORIZATION_TYPE)) {
            return Optional.of(authorizationHeader.substring(AUTHORIZATION_TYPE.length()));
        }
        return Optional.empty();
    }

    private Claims extractAllClaims(String token) {
        return (Claims)this.jwtParser.parseClaimsJws((CharSequence)token).getBody();
    }

    private static JwtParser createParser(String secret, String jwksUri) {
        JwtParserBuilder parser = Jwts.parser();
        if (org.springframework.util.StringUtils.hasText((String)jwksUri)) {
            parser.setSigningKeyResolver((SigningKeyResolver)new RemoteJwkSigningKeyResolver(jwksUri));
        } else if (secret != null) {
            parser.setSigningKey((Key)Keys.hmacShaKeyFor((byte[])secret.getBytes(StandardCharsets.UTF_8)));
        }
        return parser.setAllowedClockSkewSeconds(180L).build();
    }

    public static class Builder {
        private boolean isSecurityEnabled;
        private String secret;
        private String jwksUri;
        private JwtClaimMapping jwtClaimMapping;

        public Builder setSecurityEnabled(boolean isSecurityEnabled) {
            this.isSecurityEnabled = isSecurityEnabled;
            return this;
        }

        public Builder setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        public Builder setJwtClaimMapping(JwtClaimMapping jwtClaimMapping) {
            this.jwtClaimMapping = jwtClaimMapping;
            return this;
        }

        public JwtProcessor build() {
            if (!this.isSecurityEnabled) {
                return new JwtProcessor();
            }
            if (!org.springframework.util.StringUtils.hasText((String)this.secret) && !org.springframework.util.StringUtils.hasText((String)this.jwksUri)) {
                throw new PlatformConfigurationException("either security.secret or security.jwks-uri must be set", ErrorCode.BAD_CONFIG_SECURITY_SECRET_OR_JWKS_MISSING);
            }
            return new JwtProcessor(this.secret, this.jwksUri, this.jwtClaimMapping);
        }
    }
}

