/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.jwt;

import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JwtClaimMapping
extends HashMap<String, String> {
    public static final JwtClaimMapping DEFAULTS = new JwtClaimMapping(){

        @Override
        public String getUsernameClaim() {
            return JwtClaimMapping.USERNAME_CLAIM;
        }

        @Override
        public String getRolesClaim() {
            return "roles";
        }

        @Override
        public String getEmailClaim() {
            return "email";
        }
    };
    public static final String USERNAME_CLAIM = "preferred_username";
    public static final String ROLES_CLAIM = "roles";
    public static final String ROLES_KEY = "roles";
    public static final String USERNAME_KEY = "username";
    public static final String EMAIL_KEY = "email";
    public static final String EMAIL_CLAIM = "email";

    public String getUsername() {
        return (String)this.get(USERNAME_KEY);
    }

    public void setUsername(String username) {
        if ((username = StringUtils.trimToNull((String)username)) != null) {
            this.put(USERNAME_KEY, username);
        }
    }

    public String getRoles() {
        return (String)this.get("roles");
    }

    public void setRoles(String roles) {
        if ((roles = StringUtils.trimToNull((String)roles)) != null) {
            this.put("roles", roles);
        }
    }

    public String getEmail() {
        return (String)this.get("email");
    }

    public String getUsernameClaim() {
        return Objects.toString(this.getUsername(), USERNAME_CLAIM);
    }

    public String getRolesClaim() {
        return Objects.toString(this.getRoles(), "roles");
    }

    public String getEmailClaim() {
        return Objects.toString(this.getEmail(), "email");
    }
}

