/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.exceptions;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.security.Role;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.util.RolesProviderUtil;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.PlatformRuntimeException;
import java.util.Set;
import java.util.stream.Collectors;

public class NoPermissionsException
extends PlatformRuntimeException {
    private static final long serialVersionUID = -8089169515412802622L;
    private final String username;
    private final transient Set<Role> roles;

    public NoPermissionsException(String username, Set<Role> roles, String reason) {
        super(reason, ErrorCode.OPERATION_FORBIDDEN, 403);
        this.username = username;
        this.roles = roles;
    }

    public NoPermissionsException(String reason, SecurityContext securityContext) {
        this(securityContext.getUsername(), RolesProviderUtil.getRoles(securityContext), reason);
    }

    public String getUsername() {
        return this.username;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public Set<String> getRolesNames() {
        return this.roles.stream().map(Role::getName).collect(Collectors.toSet());
    }

    public static NoPermissionsException operationNotAllowed(SecurityContext securityContext) {
        return new NoPermissionsException(ErrorMessages.get((String)"security.operation-not-allowed"), securityContext);
    }
}

