/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.RbacPartialDeleteValidationQueryBuilder;
import com.ontotext.graphql.compiler.RbacPartialUpdateValidationQueryBuilder;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.graphql.responder.ValidationUpdateStep;
import com.ontotext.models.OperationVisitor;
import com.ontotext.models.OperationVisitorContext;
import com.ontotext.models.Selection;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Query;
import com.ontotext.models.subscriptions.Subscription;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class RbacPartialUpdateVisitor
implements OperationVisitor<Void, Context> {
    private boolean legacyMode;

    public RbacPartialUpdateVisitor(boolean legacyMode) {
        this.legacyMode = legacyMode;
    }

    public Void visit(Query query, Context context) {
        return null;
    }

    public Void visit(Selection selection, Context context) {
        return null;
    }

    public Void visit(CreateMutation mutation, Context context) {
        return null;
    }

    public Void visit(UpdateMutation mutation, Context context) {
        RbacPartialUpdateValidationQueryBuilder queryBuilder = new RbacPartialUpdateValidationQueryBuilder(mutation.getSchema(), this.legacyMode, context.getRequest().getOperationOptions());
        List<Pair<String, ValidationUpdateStep>> validationSteps = queryBuilder.toValidationSteps((Mutation)mutation);
        this.addValidationStepsToTheExecution(context.getRequest(), validationSteps);
        return null;
    }

    public Void visit(DeleteMutation deleteMutation, Context context) {
        RbacPartialDeleteValidationQueryBuilder queryBuilder = new RbacPartialDeleteValidationQueryBuilder(deleteMutation.getSchema(), this.legacyMode, context.getRequest().getOperationOptions());
        queryBuilder.toValidationSteps(deleteMutation).forEach(step -> context.getRequest().addUpdateStepAt(0, (UpdateStep)step));
        return null;
    }

    public Void visit(Subscription subscription, Context context) {
        return null;
    }

    private void addValidationStepsToTheExecution(UpdateExecution request, List<Pair<String, ValidationUpdateStep>> validationSteps) {
        int startIdx = 0;
        for (Pair<String, ValidationUpdateStep> validationStep : validationSteps) {
            boolean added = false;
            for (int i = startIdx; i < request.getUpdateSteps().size(); ++i) {
                if (!((UpdateStep)request.getUpdateSteps().get(i)).getRequestId().equals(validationStep.getKey())) continue;
                request.addUpdateStepAt(i, (UpdateStep)validationStep.getValue());
                startIdx = i;
                added = true;
                break;
            }
            if (added) continue;
            throw new IllegalArgumentException("Validation step can't be added to an update execution");
        }
    }

    public static class Context
    implements OperationVisitorContext {
        private final UpdateExecution request;

        public Context(UpdateExecution request) {
            this.request = request;
        }

        public UpdateExecution getRequest() {
            return this.request;
        }

        public Object getData() {
            return null;
        }
    }
}

