/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.EntityUpdateSparqlGenerator;
import com.ontotext.graphql.compiler.FilterBuilder;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.RbacPartialUpdateUtils;
import com.ontotext.graphql.compiler.SparqlCompilationResult;
import com.ontotext.graphql.compiler.querymodel.AbstractQuery;
import com.ontotext.graphql.compiler.querymodel.DeleteInsertQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.SparqlUpdateQuery;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.responder.ValidationUpdateStep;
import com.ontotext.models.Constraint;
import com.ontotext.models.Constraints;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class RbacPartialUpdateValidationQueryBuilder
extends EntityUpdateSparqlGenerator {
    public static final String SECURITY_RBAC_CREATE_FILTER_FAILED = "security.rbac.partialUpdate.failed";
    private boolean legacyMode;

    public RbacPartialUpdateValidationQueryBuilder(SomlSchema schema, boolean legacyMode, OperationBuilderOptions options) {
        super(schema, options, new FilterFactory());
        this.legacyMode = legacyMode;
    }

    public List<Pair<String, ValidationUpdateStep>> toValidationSteps(Mutation mutation) {
        if (!(mutation instanceof DeleteMutation) && !(mutation instanceof UpdateMutation)) {
            return Collections.emptyList();
        }
        SparqlCompilationResult compilationResult = new SparqlCompilationResult();
        for (Change change : this.getRootChanges(mutation.getChanges())) {
            ValidateUpdateNode updateNode = new ValidateUpdateNode(change, mutation);
            updateNode.generate(compilationResult);
        }
        return compilationResult.getSteps().stream().map(step -> Pair.of((Object)step.getId(), (Object)new ValidationUpdateStep(UUID.randomUUID().toString(), step.getQuery(null)))).collect(Collectors.toList());
    }

    private String getMessage(Change change) {
        return QueryValidationMessage.error((SourceLocation)change.getSourceLocation(), (String)SECURITY_RBAC_CREATE_FILTER_FAILED, (Object[])new Object[]{change.getType(), change.getShape().getId(), Constraints.asUserMessage((Set)change.getConstraints(), (Shape)change.getShape())}).toSerializedString();
    }

    class ValidateUpdateNode
    extends EntityUpdateSparqlGenerator.UpdateNode {
        ValidateUpdateNode(Change change, Mutation mutation) {
            super((EntityUpdateSparqlGenerator)RbacPartialUpdateValidationQueryBuilder.this, change, mutation);
        }

        ValidateUpdateNode(EntityUpdateSparqlGenerator.UpdateNode node) {
            super((EntityUpdateSparqlGenerator)RbacPartialUpdateValidationQueryBuilder.this, node);
        }

        void processNestedCreates(SparqlCompilationResult compilationResult) {
        }

        List<EntityUpdateSparqlGenerator.UpdateNode> getSubUpdates() {
            return super.getSubUpdates().stream().map(x$0 -> new ValidateUpdateNode((EntityUpdateSparqlGenerator.UpdateNode)x$0)).collect(Collectors.toList());
        }

        void processEntityUpdate(Value idConst, SparqlUpdateQuery mutationQuery) {
            if (this.change.getConstraints() == null) {
                return;
            }
            DeleteInsertQuery deleteInsertQuery = new DeleteInsertQuery();
            RbacPartialUpdateUtils.addInvalidatingInsert(deleteInsertQuery, (Value)RbacPartialUpdateUtils.BLANK_NODE, RbacPartialUpdateValidationQueryBuilder.this.legacyMode);
            this.addFetchPreviousResults(deleteInsertQuery);
            TriplePatternBlock where = deleteInsertQuery.getWhere();
            RbacPartialUpdateUtils.addRootConstraints(where, RbacPartialUpdateValidationQueryBuilder.this.schema, this.change.getShape(), EntityUpdateSparqlGenerator.ENTITY_IRI_VAR, RbacPartialUpdateValidationQueryBuilder.this.options);
            if (this.change.hasPreconditions()) {
                SparqlNodeSequence sequence = new SparqlNodeSequence();
                this.generatePreconditions(sequence, EntityUpdateSparqlGenerator.ENTITY_IRI_VAR);
                where.addNode((SparqlNode)sequence);
            }
            RbacPartialUpdateUtils.addConstraintsAndTrigger(where, this.getRbacConstraintsBlock(), RbacPartialUpdateValidationQueryBuilder.this.getMessage(this.change));
            this.addEntityIdBinding(idConst, where);
            mutationQuery.add((AbstractQuery)deleteInsertQuery);
        }

        private TriplePatternBlock getRbacConstraintsBlock() {
            Set changeConstraints = this.change.getConstraints();
            if (changeConstraints == null || changeConstraints.isEmpty()) {
                throw new IllegalArgumentException("Change should have constraints.");
            }
            TriplePatternBlock constraints = new TriplePatternBlock();
            if (changeConstraints.size() > 1) {
                this.generateConstraints(constraints, this.change);
            } else {
                ((Optional)FilterFactory.filterGenerator((Var)EntityUpdateSparqlGenerator.ENTITY_IRI_VAR, (FilterBuilder)FilterFactory.getFilterBuilder((SomlSchema)RbacPartialUpdateValidationQueryBuilder.this.schema, (OperationBuilderOptions)RbacPartialUpdateValidationQueryBuilder.this.options, (FilterFactory)RbacPartialUpdateValidationQueryBuilder.this.filterFactory)).apply(((Constraint)changeConstraints.iterator().next()).getFilter())).ifPresent(arg_0 -> ((TriplePatternBlock)constraints).addNode(arg_0));
            }
            return constraints;
        }
    }
}

