/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.Bound;
import com.ontotext.graphql.compiler.querymodel.DeleteInsertQuery;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Not;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TempVar;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.Constraints;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.LinkedList;

public class RbacPartialUpdateUtils {
    private static final String ENTITY_IRI = "entity_iri";
    private static final Var ENTITY_IRI_VAR = new Var("entity_iri");
    static final String IGNORE = "ignore";
    static final Iri ONTO_ROLLBACK = new Iri("http://www.ontotext.com/rollback");
    static final Var TRIGGER = new Var("trigger");
    static final Var MATCH = new Var("match");
    static final Var REASON = new Var("reason");
    static final String TRIGGER_VALUE = "http://ontotext.com/tx";
    static final Literal BLANK_NODE = new Literal((Object)"_:b");

    static void addInvalidatingInsert(DeleteInsertQuery query, Value trigger, boolean legacyMode) {
        if (!legacyMode) {
            query.getInsert().addNode((SparqlNode)new TriplePattern(trigger, (Value)ONTO_ROLLBACK, (Value)REASON));
        } else {
            NamedGraphTriplePatternBlock ng = new NamedGraphTriplePatternBlock((Value)new Iri("http://www.ontotext.com/explicit"));
            ng.addNode((SparqlNode)new TriplePattern(trigger, (Value)ONTO_ROLLBACK, (Value)REASON));
            query.getInsert().addNode((SparqlNode)ng);
        }
    }

    static TriplePatternBlock generateTriggerBlock(Var entityVar, String message) {
        TriplePatternBlock triggerBlock = new TriplePatternBlock();
        triggerBlock.addNode((SparqlNode)new Filter((SparqlNode)new Bound((SparqlNode)new TempVar(entityVar, IGNORE))));
        triggerBlock.addNode((SparqlNode)new Filter((SparqlNode)new Not((SparqlNode)new Bound((SparqlNode)MATCH))));
        triggerBlock.addNode((SparqlNode)new Bind((SparqlNode)Literal.asString((String)message), (Value)REASON));
        return triggerBlock;
    }

    static void addConstraintsAndTrigger(TriplePatternBlock where, TriplePatternBlock constraints, String message) {
        constraints.addNode((SparqlNode)new Bind((SparqlNode)new Literal((Object)"true"), (Value)MATCH));
        where.addNode((SparqlNode)new Optional((SparqlNode)constraints));
        where.addNode((SparqlNode)RbacPartialUpdateUtils.generateTriggerBlock(ENTITY_IRI_VAR, message));
    }

    static void addRootConstraints(TriplePatternBlock where, SomlSchema schema, Shape shape, Var subject, OperationBuilderOptions options) {
        LinkedList seq = new LinkedList();
        new ConstraintGenerator(schema, options).addBoTypeConstraint(Constraints.fromShapeIds((String[])new String[]{shape.getId()}), seq, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(subject).build());
        where.addAll(seq);
    }
}

