/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.sparql.QueryInvocationException;
import com.ontotext.sparql.QueryInvocationExceptionMapper;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacExceptionMapper
implements QueryInvocationExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RbacExceptionMapper.class);
    private static final Pattern TX_ROLLBACK_PATTERN = Pattern.compile(".*TX rollbacked by request. Reason:(.*)");
    private static final String ONTO_EXPLICIT = "You are not allowed to add statements in context http://www.ontotext.com/explicit";

    public Optional<Throwable> map(Throwable ex) {
        for (Throwable current = ex; current != null; current = current.getCause()) {
            String message = current.getMessage();
            if (message == null) continue;
            Matcher matcher = TX_ROLLBACK_PATTERN.matcher(message);
            if (!matcher.matches()) continue;
            String actual = matcher.group(1);
            try {
                return Optional.of(new QueryInvocationException(QueryValidationMessage.serializeFromSerializedString((String)actual)));
            }
            catch (IOException ioe) {
                LOGGER.error("Could not deserialize error message: {}", (Object)message);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

