/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.sparql.RemoteRepositoryImplConfig;
import com.ontotext.sparql.RepositoryCreator;
import com.ontotext.sparql.SparqlEndpoint;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedRepositoryCreator
implements RepositoryCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ID_KEY = "%id%";
    private final String template;
    private final String repoKey;

    public TemplatedRepositoryCreator(String template, String repoKey) {
        this.template = template;
        this.repoKey = Objects.toString(StringUtils.trimToNull((String)repoKey), ID_KEY);
    }

    @Override
    @NotNull
    public Repository createRepository(RepositoryManager repositoryManager, SparqlEndpoint endpoint) {
        RepositoryConfig repositoryConfig = this.getConfig(endpoint.getRepository());
        try {
            repositoryManager.addRepositoryConfig(repositoryConfig);
        }
        catch (RepositoryException re) {
            if (re.getMessage() != null && re.getMessage().contains("REPOSITORY EXISTS")) {
                LOGGER.warn("Detected concurrent repository creation at {} for repository {}", (Object)endpoint.getAddress(), (Object)endpoint.getRepository());
            }
            throw re;
        }
        return repositoryManager.getRepository(endpoint.getRepository());
    }

    private RepositoryConfig getConfig(String id) {
        RepositoryConfig repositoryConfig;
        String templateWithId = this.template.replace(this.repoKey, id);
        StringReader reader = new StringReader(templateWithId);
        try {
            Model model = Rio.parse((Reader)reader, (String)"http://example.com/", (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
            repositoryConfig = RemoteRepositoryImplConfig.create(model, id);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RepositoryConfigException((Throwable)ioe);
            }
        }
        ((Reader)reader).close();
        return repositoryConfig;
    }
}

