/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.ThreadLocalContext;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import com.ontotext.soaas.common.logging.LoggingContext;
import com.ontotext.sparql.SparqlEndpoint;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SparqlEndpointRequestContext {
    public static final String PASSTHROUGH_HEADERS = "PASSTHROUGH_HEADERS";
    private static final Set<String> BOOLEAN_VALUES = Stream.of("true", "false").collect(Collectors.toSet());
    public static final int UPPER_LIMIT = 50000000;
    public static final int LOWER_LIMIT = 1000;
    private static final List<ThreadLocalStateCopier<?>> COPIER_LIST = new CopyOnWriteArrayList();
    public static final ThreadLocalStateCopier<SparqlEndpoint.ExecutionMode> QUERY_MODE = SparqlEndpointRequestContext.addCopyConfig(() -> SparqlEndpointRequestContext.getQueryMode().orElse(null), SparqlEndpointRequestContext::setQueryMode);
    public static final ThreadLocalStateCopier<Integer> SUB_QUERY_RESULT_LIMIT = SparqlEndpointRequestContext.addCopyConfig(SparqlEndpointRequestContext::getSubQueryResultLimit, SparqlEndpointRequestContext::setTupleLimitInternal);
    public static final ThreadLocalStateCopier<Boolean> IS_SUB_QUERY_FULL_RESULT_REQUEST = SparqlEndpointRequestContext.addCopyConfig(() -> SparqlEndpointRequestContext.isSubQueryFullResultRequest().orElse(null), SparqlEndpointRequestContext::setFullResultInternal);
    public static final ThreadLocalStateCopier<Boolean> EXPAND_OVER_SAME_AS = SparqlEndpointRequestContext.addCopyConfig(SparqlEndpointRequestContext::getExpandOverSameAs, SparqlEndpointRequestContext::setExpandOverSameAs);
    public static final ThreadLocalStateCopier<Boolean> INCLUDE_INFERRED = SparqlEndpointRequestContext.addCopyConfig(SparqlEndpointRequestContext::getIncludeInferred, SparqlEndpointRequestContext::setIncludeInferred);
    public static final ThreadLocalStateCopier<String> REPOSITORY = SparqlEndpointRequestContext.addCopyConfig(SparqlEndpointRequestContext::getRepository, SparqlEndpointRequestContext::setRepository);
    public static final ThreadLocalStateCopier<List<Pair<String, String>>> PASSTHROUGH_HEADERS_COPIER = SparqlEndpointRequestContext.addCopyConfig(() -> SparqlEndpointRequestContext.getPassthroughHeaders().orElse(null), SparqlEndpointRequestContext::setPassthroughHeaders);
    public static final ThreadLocalStateCopier<String> USER = SparqlEndpointRequestContext.addCopyConfig(LoggingContext::getCurrentUser, LoggingContext::setCurrentUser);
    public static final ThreadLocalStateCopier<String> REQUEST_ID = SparqlEndpointRequestContext.addCopyConfig(LoggingContext::getRequestId, LoggingContext::setRequestId);

    private SparqlEndpointRequestContext() {
    }

    public static <E> ThreadLocalStateCopier<E> createCopyConfig(Supplier<E> supplier, Consumer<E> consumer) {
        return new FunctionalThreadLocalStateCopier<E>(supplier, consumer);
    }

    public static <E> ThreadLocalStateCopier<E> addCopyConfig(Supplier<E> supplier, Consumer<E> consumer) {
        return SparqlEndpointRequestContext.addCopyConfig(SparqlEndpointRequestContext.createCopyConfig(supplier, consumer));
    }

    public static <E> ThreadLocalStateCopier<E> addCopyConfig(ThreadLocalStateCopier<E> copier) {
        COPIER_LIST.add(copier);
        return copier;
    }

    public static State getState() {
        return new State(COPIER_LIST);
    }

    public static State setState(State state) {
        State previous = SparqlEndpointRequestContext.getState();
        if (state != null) {
            state.materializeState();
        }
        return previous;
    }

    public static void setSubQueryResultLimit(String headerValue) {
        if (headerValue != null) {
            try {
                BigInteger bigInteger = new BigInteger(headerValue);
                int limit = bigInteger.intValueExact();
                if (limit < 1000 || limit > 50000000) {
                    throw SparqlEndpointRequestContext.invalidHeaderValue("X-GraphDB-SplitQueryLimit", headerValue, " Allowed value range: [1000, 50000000]");
                }
                SparqlEndpointRequestContext.setTupleLimitInternal(limit);
            }
            catch (ArithmeticException | NumberFormatException ex) {
                throw SparqlEndpointRequestContext.invalidHeaderValue("X-GraphDB-SplitQueryLimit", headerValue, " Allowed value range: [1000, 50000000]");
            }
        } else {
            SparqlEndpointRequestContext.clearSubQueryResultLimit();
        }
    }

    private static void setTupleLimitInternal(Integer limit) {
        if (limit == null) {
            SparqlEndpointRequestContext.clearSubQueryResultLimit();
        } else {
            ThreadLocalContext.put((String)"X-GraphDB-SplitQueryLimit", (Object)limit);
        }
    }

    public static Integer getSubQueryResultLimit() {
        return (Integer)ThreadLocalContext.get((String)"X-GraphDB-SplitQueryLimit");
    }

    static void clearSubQueryResultLimit() {
        ThreadLocalContext.remove((String)"X-GraphDB-SplitQueryLimit");
    }

    static void clearExpandOverSameAs() {
        ThreadLocalContext.remove((String)"X-Expand-Over-Owl-SameAs");
    }

    public static Boolean getExpandOverSameAs() {
        return (Boolean)ThreadLocalContext.get((String)"X-Expand-Over-Owl-SameAs");
    }

    public static void setExpandOverSameAs(String headerValue) {
        if (headerValue == null) {
            SparqlEndpointRequestContext.clearExpandOverSameAs();
        } else if (BOOLEAN_VALUES.contains(headerValue = headerValue.toLowerCase())) {
            SparqlEndpointRequestContext.setExpandOverSameAs(Boolean.parseBoolean(headerValue));
        } else {
            throw SparqlEndpointRequestContext.invalidBooleanValue("X-Expand-Over-Owl-SameAs", headerValue);
        }
    }

    public static void setExpandOverSameAs(Boolean includeInferred) {
        if (includeInferred == null) {
            SparqlEndpointRequestContext.clearExpandOverSameAs();
        } else {
            ThreadLocalContext.put((String)"X-Expand-Over-Owl-SameAs", (Object)includeInferred);
        }
    }

    static void clearIncludeInferred() {
        ThreadLocalContext.remove((String)"X-Include-Inferred");
    }

    public static Boolean getIncludeInferred() {
        return (Boolean)ThreadLocalContext.get((String)"X-Include-Inferred");
    }

    public static void setIncludeInferred(String headerValue) {
        if (headerValue == null) {
            SparqlEndpointRequestContext.clearIncludeInferred();
        } else if (BOOLEAN_VALUES.contains(headerValue = headerValue.toLowerCase())) {
            SparqlEndpointRequestContext.setIncludeInferred(Boolean.parseBoolean(headerValue));
        } else {
            throw SparqlEndpointRequestContext.invalidBooleanValue("X-Include-Inferred", headerValue);
        }
    }

    public static void setIncludeInferred(Boolean includeInferred) {
        if (includeInferred == null) {
            SparqlEndpointRequestContext.clearIncludeInferred();
        } else {
            ThreadLocalContext.put((String)"X-Include-Inferred", (Object)includeInferred);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSubQueryFullResultRequest(String headerValue) {
        if (headerValue != null) {
            if (!BOOLEAN_VALUES.contains(headerValue = headerValue.toLowerCase())) throw SparqlEndpointRequestContext.invalidBooleanValue("X-GraphDB-SplitQueryFullResult", headerValue);
            SparqlEndpointRequestContext.setFullResultInternal(Boolean.parseBoolean(headerValue));
            return;
        } else {
            SparqlEndpointRequestContext.clearSubQueryFullResultRequest();
        }
    }

    private static void setFullResultInternal(Boolean value) {
        if (value == null) {
            SparqlEndpointRequestContext.clearSubQueryFullResultRequest();
        } else {
            ThreadLocalContext.put((String)"X-GraphDB-SplitQueryFullResult", (Object)value);
        }
    }

    public static void clearRepository() {
        ThreadLocalContext.remove((String)"X-Repository");
    }

    public static void setRepository(String repository) {
        if (repository == null) {
            SparqlEndpointRequestContext.clearRepository();
        } else {
            ThreadLocalContext.put((String)"X-Repository", (Object)repository);
        }
    }

    public static String getRepository() {
        return (String)ThreadLocalContext.get((String)"X-Repository");
    }

    public static Optional<Boolean> isSubQueryFullResultRequest() {
        Boolean value = (Boolean)ThreadLocalContext.get((String)"X-GraphDB-SplitQueryFullResult");
        return Optional.ofNullable(value);
    }

    static void clearSubQueryFullResultRequest() {
        ThreadLocalContext.remove((String)"X-GraphDB-SplitQueryFullResult");
    }

    public static void setQueryMode(SparqlEndpoint.ExecutionMode executionMode) {
        if (executionMode == null) {
            SparqlEndpointRequestContext.clearQueryMode();
        } else {
            ThreadLocalContext.put((String)"X-GraphDB-SplitQuery", (Object)((Object)executionMode));
        }
    }

    public static Optional<SparqlEndpoint.ExecutionMode> getQueryMode() {
        return Optional.ofNullable((SparqlEndpoint.ExecutionMode)((Object)ThreadLocalContext.get((String)"X-GraphDB-SplitQuery")));
    }

    public static boolean isSubQueryMode() {
        SparqlEndpoint.ExecutionMode value = (SparqlEndpoint.ExecutionMode)((Object)ThreadLocalContext.get((String)"X-GraphDB-SplitQuery"));
        return value == null || value == SparqlEndpoint.ExecutionMode.SUBQUERY;
    }

    public static boolean isSplitQueryMode() {
        SparqlEndpoint.ExecutionMode value = (SparqlEndpoint.ExecutionMode)((Object)ThreadLocalContext.get((String)"X-GraphDB-SplitQuery"));
        return value == SparqlEndpoint.ExecutionMode.SPLIT;
    }

    public static void clearQueryMode() {
        ThreadLocalContext.remove((String)"X-GraphDB-SplitQuery");
    }

    @NotNull
    private static BadRequestException invalidHeaderValue(String headerKey, String headerValue, String range) {
        return new BadRequestException(String.format("Invalid value for HTTP header %s: %s.%s", headerKey, headerValue, range), ErrorCode.INVALID_HEADER_VALUE);
    }

    @NotNull
    private static BadRequestException invalidBooleanValue(String headerKey, String headerValue) {
        return SparqlEndpointRequestContext.invalidHeaderValue(headerKey, headerValue, " Valid values are: true, false.");
    }

    public static Optional<List<Pair<String, String>>> getPassthroughHeaders() {
        return Optional.ofNullable((List)ThreadLocalContext.get((String)PASSTHROUGH_HEADERS));
    }

    public static void setPassthroughHeaders(List<Pair<String, String>> headers) {
        if (headers != null) {
            ThreadLocalContext.put((String)PASSTHROUGH_HEADERS, headers);
        } else {
            SparqlEndpointRequestContext.clearPassthroughHeaders();
        }
    }

    public static void clearPassthroughHeaders() {
        ThreadLocalContext.remove((String)PASSTHROUGH_HEADERS);
    }

    public static boolean hasHeader(String headerName) {
        return SparqlEndpointRequestContext.getPassthroughHeaders().filter(headers -> headers.stream().anyMatch(pair -> ((String)pair.getKey()).equals(headerName))).isPresent();
    }

    public static boolean hasSecurityInformationInRequest() {
        return SparqlEndpointRequestContext.hasHeader("Authorization");
    }

    public static void clearAll() {
        ThreadLocalContext.clear();
    }

    public static Runnable decorateTask(Runnable task) {
        State state = SparqlEndpointRequestContext.getState();
        return () -> {
            State oldState = SparqlEndpointRequestContext.getState();
            try {
                SparqlEndpointRequestContext.setState(state);
                task.run();
            }
            finally {
                SparqlEndpointRequestContext.setState(oldState);
            }
        };
    }

    public static Runnable withRepository(Endpoint endpoint, Runnable task) {
        State state = SparqlEndpointRequestContext.getState();
        return () -> {
            State oldState = SparqlEndpointRequestContext.getState();
            try {
                SparqlEndpointRequestContext.setState(state);
                if (endpoint instanceof SparqlEndpoint) {
                    SparqlEndpointRequestContext.setRepository(((SparqlEndpoint)endpoint).getRepository());
                }
                task.run();
            }
            finally {
                SparqlEndpointRequestContext.setState(oldState);
            }
        };
    }

    public static <E> Callable<E> withRepository(Endpoint endpoint, Callable<E> task) {
        State state = SparqlEndpointRequestContext.getState();
        return () -> {
            State oldState = SparqlEndpointRequestContext.getState();
            try {
                SparqlEndpointRequestContext.setState(state);
                if (endpoint instanceof SparqlEndpoint) {
                    SparqlEndpointRequestContext.setRepository(((SparqlEndpoint)endpoint).getRepository());
                }
                Object v = task.call();
                return v;
            }
            finally {
                SparqlEndpointRequestContext.setState(oldState);
            }
        };
    }

    private static class FunctionalThreadLocalStateCopier<V>
    implements ThreadLocalStateCopier<V> {
        private final Supplier<V> supplier;
        private final Consumer<V> consumer;

        private FunctionalThreadLocalStateCopier(Supplier<V> supplier, Consumer<V> consumer) {
            this.supplier = supplier;
            this.consumer = consumer;
        }

        @Override
        @Nullable
        public V getValue() {
            return this.supplier.get();
        }

        @Override
        public void setValue(@Nullable V value) {
            this.consumer.accept(value);
        }
    }

    public static interface ThreadLocalStateCopier<V> {
        @Nullable
        public V getValue();

        public void setValue(@Nullable V var1);
    }

    public static class State {
        private final Pair<ThreadLocalStateCopier<Object>, Object>[] theadLocalState;

        private State(List<ThreadLocalStateCopier<?>> copierList) {
            this.theadLocalState = this.readState(copierList);
        }

        private Pair<ThreadLocalStateCopier<Object>, Object>[] readState(List<ThreadLocalStateCopier<?>> copierList) {
            Pair[] theadLocalState = new Pair[copierList.size()];
            int index = 0;
            for (ThreadLocalStateCopier<?> copier : copierList) {
                Object value = copier.getValue();
                theadLocalState[index++] = Pair.of(copier, value);
            }
            return theadLocalState;
        }

        public <V> Optional<V> get(ThreadLocalStateCopier<V> reader) {
            return Stream.of(this.theadLocalState).filter(pair -> pair.getLeft() == reader).findFirst().map(Pair::getRight);
        }

        void materializeState() {
            for (Pair<ThreadLocalStateCopier<Object>, Object> pair : this.theadLocalState) {
                ((ThreadLocalStateCopier)pair.getLeft()).setValue(pair.getRight());
            }
        }
    }
}

