/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.sparql.AddressManager;
import com.ontotext.sparql.SparqlClusterConfigurations;
import com.ontotext.sparql.SparqlEndpoint;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.Nullable;

public class SparqlEndpointConfiguration
implements EndpointProvider {
    public static final int DEFAULT_CONCURRENT_CONNECTIONS = 500;
    public static final int DEFAULT_MAX_RETRIES = 0;
    public static final int DEFAULT_MAX_RETRY_INTERVAL = 2001;
    public static final int DEFAULT_CONNECT_TIMEOUT = 10001;
    public static final int DEFAULT_SOCKET_TIMEOUT = 0;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 10001;
    public static final int DEFAULT_HEALTH_TIMEOUTS = 5001;
    private static final BasicHeader LOCAL_CONSISTENCY_HEADER = new BasicHeader("X-GraphDB-Local-Consistency", "last-committed");
    private static final Pattern CLAIM_KEY_PATTERN = Pattern.compile("\\$\\{ctx\\.claims\\.([\\w-]+):?([\\w-]+)?}");
    private String address;
    private String repository;
    private String username;
    private String credentials;
    private Set<String> httpHeadersPassthrough;
    private int maxConcurrentConnections = 500;
    private int connectionRequestTimeout = 10001;
    private int connectTimeout = 10001;
    private int socketTimeout = 0;
    private int maxRetries = 0;
    private int retryInterval = 2001;
    private String retryHttpCodes;
    private int healthCheckTimeout = 5001;
    private SparqlClusterConfigurations cluster = new SparqlClusterConfigurations();
    private SparqlClusterConfigurations healthCluster = new SparqlClusterConfigurations();
    private int maxConcurrentRequests;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRepositoryFromClaim(UnaryOperator<String> claimsLookup, @Nullable UnaryOperator<String> defaultRepoMapper) {
        UnaryOperator<Object> repositoryFallback = defaultRepoMapper == null ? UnaryOperator.identity() : defaultRepoMapper;
        String repo = this.getRepository();
        if (repo == null || !repo.startsWith("$")) {
            return (String)repositoryFallback.apply(repo);
        }
        Matcher matcher = CLAIM_KEY_PATTERN.matcher(repo);
        if (!matcher.matches()) {
            String message = String.format("ERROR: %s: Invalid repository mapping: '%s'. Expected format is: '${ctx.claims.<claim_key_to_repository>:<default_repository>}'", ErrorCode.BAD_CONFIG_REPOSITORY_NOT_FOUND.getCode(), repo);
            throw new IllegalArgumentException(message);
        }
        String claimKey = matcher.group(1);
        String defaultRepo = StringUtils.trimToNull((String)matcher.group(2));
        String resolvedRepository = (String)claimsLookup.apply(claimKey);
        if (resolvedRepository == null) {
            return (String)repositoryFallback.apply(defaultRepo);
        }
        return resolvedRepository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public int getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public void setMaxConcurrentConnections(int maxConcurrentConnections) {
        if (maxConcurrentConnections <= 0) {
            this.maxConcurrentConnections = 500;
            return;
        }
        this.maxConcurrentConnections = maxConcurrentConnections;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = Math.max(connectionRequestTimeout, 0);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = Math.max(connectTimeout, 0);
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = Math.max(socketTimeout, 0);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            this.maxRetries = 0;
            return;
        }
        this.maxRetries = maxRetries;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        if (retryInterval <= 0) {
            this.retryInterval = 2001;
            return;
        }
        this.retryInterval = retryInterval;
    }

    public SparqlEndpoint getEndpoint() {
        SparqlEndpoint sparqlEndpoint = StringUtils.isBlank((CharSequence)this.getUsername()) || StringUtils.isBlank((CharSequence)this.getCredentials()) ? SparqlEndpoint.instance(this.getAddress(), this.getRepository()) : SparqlEndpoint.instance(this.getAddress(), this.getRepository(), this.getUsername(), this.getCredentials());
        return sparqlEndpoint.setMaxConcurrentConnections(this.getMaxConcurrentConnections()).setSocketTimeout(this.getSocketTimeout()).setConnectTimeout(this.getConnectTimeout()).setConnectionRequestTimeout(this.getConnectionRequestTimeout()).setRetryInterval(this.getRetryInterval()).setMaxRetries(this.getMaxRetries()).addHeader((Header)LOCAL_CONSISTENCY_HEADER).setClusterConfigurations(SparqlEndpointConfiguration.wrap(this.getCluster())).setRetryHttpCodes(this.getRetryHttpCodes()).setHealthCacheTimeout(this.getHealthCheckTimeout());
    }

    public SparqlClusterConfigurations getCluster() {
        return this.cluster;
    }

    public void setCluster(SparqlClusterConfigurations cluster) {
        this.cluster = cluster;
    }

    public SparqlEndpoint getHealthEndpoint() {
        SparqlEndpoint endpoint = this.getEndpoint();
        int healthTimeout = this.getHealthCheckTimeout();
        endpoint.setSocketTimeout(healthTimeout);
        endpoint.setConnectTimeout(healthTimeout / 4);
        endpoint.setConnectionRequestTimeout(healthTimeout);
        endpoint.setMaxRetries(0);
        endpoint.setRetryHttpCodes("000");
        endpoint.setClusterConfigurations(SparqlEndpointConfiguration.wrap(this.healthCluster));
        SparqlClusterConfigurations clusterConfigurations = endpoint.getClusterConfigurations();
        clusterConfigurations.setClusterStatusConnectTimeout(healthTimeout);
        clusterConfigurations.setLeaderDiscoveryRetryDelay(0);
        clusterConfigurations.setLeaderDiscoveryRetries(0);
        return endpoint;
    }

    public int getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public void setHealthCheckTimeout(int healthCheckTimeout) {
        if (healthCheckTimeout < 0) {
            this.healthCheckTimeout = 5001;
            return;
        }
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public String getRetryHttpCodes() {
        return this.retryHttpCodes;
    }

    public void setRetryHttpCodes(String retryHttpCodes) {
        this.retryHttpCodes = retryHttpCodes;
    }

    public Set<String> getHttpHeadersPassthrough() {
        return this.httpHeadersPassthrough;
    }

    public void setHttpHeadersPassthrough(Set<String> httpHeadersPassthrough) {
        this.httpHeadersPassthrough = httpHeadersPassthrough;
    }

    protected static SparqlClusterConfigurations wrap(SparqlClusterConfigurations delegate) {
        if (delegate instanceof DelegatingSparqlClusterConfigurations) {
            return delegate;
        }
        return new DelegatingSparqlClusterConfigurations(delegate);
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public void setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = Math.max(maxConcurrentRequests, 0);
    }

    public static class DelegatingSparqlClusterConfigurations
    extends SparqlClusterConfigurations {
        private final SparqlClusterConfigurations delegate;

        protected DelegatingSparqlClusterConfigurations(SparqlClusterConfigurations copyFrom) {
            super(copyFrom);
            this.delegate = copyFrom;
        }

        @Override
        public void setExecutorService(ExecutorService executorService) {
            this.delegate.setExecutorService(executorService);
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.delegate.getExecutorService();
        }

        @Override
        public void setAddressManager(AddressManager addressManager) {
            this.delegate.setAddressManager(addressManager);
        }

        @Override
        public AddressManager getAddressManager() {
            return this.delegate.getAddressManager();
        }
    }
}

