/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.repository.http.HttpUtils;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.sparql.SparqlClusterConfigurations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.eclipse.rdf4j.http.protocol.Protocol;

public class SparqlEndpoint
implements Endpoint {
    public static final String LOCAL_CONSISTENCY = "X-GraphDB-Local-Consistency";
    public static final String SUBQUERY_EXECUTION_HEADER = "X-GraphDB-SplitQuery";
    public static final String SUBQUEY_LIMIT_HEADER = "X-GraphDB-SplitQueryLimit";
    public static final String SUBQUEY_FULL_RESULT = "X-GraphDB-SplitQueryFullResult";
    private String address;
    private String repository;
    private String username;
    private String credentials;
    private int maxConcurrentConnections;
    private int connectionRequestTimeout;
    private int connectTimeout;
    private int socketTimeout;
    private int maxRetries;
    private int retryInterval;
    private int maxTupleResults;
    private String retryHttpCodes;
    private int healthCacheTimeout;
    private SparqlClusterConfigurations clusterConfigurations = new SparqlClusterConfigurations();
    private Collection<Header> headers = new ArrayList<Header>();
    private Boolean subqueryFullResult;
    private ExecutionMode executionMode = ExecutionMode.SUBQUERY;
    private boolean cartesianProtectionEnabled;

    public SparqlEndpoint() {
    }

    public SparqlEndpoint(SparqlEndpoint other) {
        this.address = other.address;
        this.repository = other.repository;
        this.username = other.username;
        this.credentials = other.credentials;
        this.maxConcurrentConnections = other.maxConcurrentConnections;
        this.connectionRequestTimeout = other.connectionRequestTimeout;
        this.connectTimeout = other.connectTimeout;
        this.socketTimeout = other.socketTimeout;
        this.maxRetries = other.maxRetries;
        this.retryInterval = other.retryInterval;
        this.maxTupleResults = other.maxTupleResults;
        this.retryHttpCodes = other.retryHttpCodes;
        this.healthCacheTimeout = other.healthCacheTimeout;
        this.clusterConfigurations = new SparqlClusterConfigurations(other.clusterConfigurations);
        this.headers.addAll(other.headers);
        this.subqueryFullResult = other.subqueryFullResult;
        this.executionMode = other.executionMode;
        this.cartesianProtectionEnabled = other.cartesianProtectionEnabled;
    }

    public static SparqlEndpoint instance(String address, String repository) {
        SparqlEndpoint repositoryInfo = new SparqlEndpoint();
        repositoryInfo.setAddress(Objects.requireNonNull(address, "Repository address is required"));
        repositoryInfo.setRepository(repository);
        return repositoryInfo;
    }

    public static SparqlEndpoint instance(String address, String repository, String username, String credentials) {
        SparqlEndpoint repositoryInfo = SparqlEndpoint.instance(address, repository);
        repositoryInfo.setUsername(Objects.requireNonNull(username, "User name is required"));
        repositoryInfo.setCredentials(Objects.requireNonNull(credentials, "User credentials are required"));
        return repositoryInfo;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRepository() {
        return this.repository;
    }

    public static String getRepository(Endpoint endpoint) {
        return endpoint instanceof SparqlEndpoint ? ((SparqlEndpoint)endpoint).getRepository() : null;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public boolean isSecuritySet() {
        return StringUtils.isNotBlank((CharSequence)this.getUsername()) && StringUtils.isNotBlank((CharSequence)this.getCredentials());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SparqlEndpoint)) {
            return false;
        }
        SparqlEndpoint that = (SparqlEndpoint)obj;
        return this.getAddress().equals(that.getAddress()) && this.getRepository().equals(that.getRepository()) && Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getCredentials(), that.getCredentials());
    }

    public int hashCode() {
        return Objects.hash(this.getAddress(), this.getRepository(), this.getUsername(), this.getCredentials());
    }

    public String toString() {
        return HttpUtils.getAddresses(this).stream().map(addrs -> Protocol.getRepositoryLocation((String)addrs, (String)this.repository)).collect(Collectors.joining(", "));
    }

    public int getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public SparqlEndpoint setMaxConcurrentConnections(int maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public SparqlEndpoint setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public SparqlEndpoint setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public SparqlEndpoint setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public SparqlEndpoint setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public SparqlEndpoint setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public Collection<Header> getHeaders() {
        return this.headers;
    }

    public SparqlEndpoint addHeaders(Collection<Header> headers) {
        this.headers.addAll(headers);
        return this;
    }

    public SparqlEndpoint addHeader(Header header) {
        CollectionsUtil.addIfNotNull(this.headers, (Object)header);
        return this;
    }

    public int getMaxTupleResults() {
        if (this.maxTupleResults <= 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxTupleResults;
    }

    public SparqlEndpoint setMaxTupleResults(int maxTupleResults) {
        this.maxTupleResults = maxTupleResults;
        return this;
    }

    public String getConnectionInfo() {
        return String.format("MaxConcurrentConnections=%d, SocketTimeout=%d, ConnectTimeout=%d, ConnectionRequestTimeout=%d, MaxRetries=%d, RetryInterval=%d, RetryHttpCodes=%s, MaxTupleResults=%d, ClusterCfg=%s", this.getMaxConcurrentConnections(), this.getSocketTimeout(), this.getConnectTimeout(), this.getConnectionRequestTimeout(), this.getMaxRetries(), this.getRetryInterval(), this.getRetryHttpCodes(), this.getMaxTupleResults(), this.getClusterConfigurations());
    }

    public SparqlEndpoint setSubqueryFullResult(Boolean subqueryFullResult) {
        this.subqueryFullResult = subqueryFullResult;
        return this;
    }

    public Boolean getSubqueryFullResult() {
        return this.subqueryFullResult;
    }

    public SparqlEndpoint setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
        return this;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public boolean isCartesianProtectionEnabled() {
        return this.cartesianProtectionEnabled;
    }

    public SparqlEndpoint setCartesianProtectionEnabled(boolean cartesianProtectionEnabled) {
        this.cartesianProtectionEnabled = cartesianProtectionEnabled;
        return this;
    }

    public SparqlClusterConfigurations getClusterConfigurations() {
        return this.clusterConfigurations;
    }

    public SparqlEndpoint setClusterConfigurations(SparqlClusterConfigurations clusterConfigurations) {
        this.clusterConfigurations = Objects.requireNonNull(clusterConfigurations, "Cluster configurations cannot be null");
        return this;
    }

    public String getRetryHttpCodes() {
        return this.retryHttpCodes;
    }

    public SparqlEndpoint setRetryHttpCodes(String retryHttpCodes) {
        this.retryHttpCodes = retryHttpCodes;
        return this;
    }

    public int getHealthCacheTimeout() {
        return this.healthCacheTimeout;
    }

    public SparqlEndpoint setHealthCacheTimeout(int healthCacheTimeout) {
        this.healthCacheTimeout = healthCacheTimeout;
        return this;
    }

    public static enum ExecutionMode {
        SPLIT,
        SUBQUERY;

    }
}

