/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.models.ShaclSchema;

public class ShaclStatusChangedEvent {
    private final EventType eventType;
    private final ShaclSchema shaclSchema;

    public ShaclStatusChangedEvent(EventType eventType, ShaclSchema shaclSchema) {
        this.eventType = eventType;
        this.shaclSchema = shaclSchema;
    }

    public static ShaclStatusChangedEvent enabled(ShaclSchema shaclSchema) {
        return new ShaclStatusChangedEvent(EventType.ENABLED, shaclSchema);
    }

    public static ShaclStatusChangedEvent disabled() {
        return new ShaclStatusChangedEvent(EventType.DISABLED, null);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public boolean isEnabled() {
        return this.getEventType() == EventType.ENABLED;
    }

    public ShaclSchema getShaclSchema() {
        return this.shaclSchema;
    }

    public String toString() {
        return "ShaclStatusChangedEvent{" + String.valueOf((Object)this.eventType) + "}";
    }

    public static enum EventType {
        ENABLED,
        DISABLED;

    }
}

