/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.ShaclConstraintViolation;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.ShaclValidationException;
import com.ontotext.models.ValidationReportParser;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.repository.http.HttpUtils;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.exceptions.InvalidConfigurationException;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.exceptions.ShaclBindException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.AutoLoadingSparqlConnectionFactory;
import com.ontotext.sparql.ShaclChangedListener;
import com.ontotext.sparql.ShaclStatusChangedEvent;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.rdf4j.common.exception.ValidationException;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ShaclManager {
    public static final String BEAN_NAME = "shaclManager";
    public static final String HEALTH_BEAN_NAME = "healthShaclManager";
    public static final String DIRECT_UPDATES_EXCEPTION = "Direct updates are not allowed in cluster mode";
    public static final String SHACL_FAILED_VALIDATION = "Failed SHACL validation";
    private SparqlEndpoint endpoint;
    private SparqlConnectionFactory factory;
    private static final Logger LOGGER = Loggers.shaclLogger();
    private ValidationReportParser validationParser = new ValidationReportParser();
    private boolean shaclRepo;
    private final Boolean enabled;
    private Boolean clustered;
    private Boolean initialShaclMode = Boolean.TRUE;
    private ShaclSchema schema;
    private boolean initialized = false;
    private final List<ShaclChangedListener> listeners = new CopyOnWriteArrayList<ShaclChangedListener>();

    public ShaclManager(SparqlEndpoint endpoint, Boolean enabled) {
        this(endpoint, new AutoLoadingSparqlConnectionFactory(), enabled);
    }

    public ShaclManager(SparqlEndpoint endpoint, SparqlConnectionFactory factory, Boolean enabled) {
        this.enabled = (Boolean)ObjectsUtil.getOrDefault((Object)enabled, (Object)Boolean.FALSE);
        this.endpoint = endpoint;
        this.factory = factory;
    }

    public void initialize() {
        this.initialized = true;
        this.shaclRepo = null != this.endpoint && null != this.endpoint.getAddress() ? this.checkShaclEnabledForRepository(true) : false;
        if (Boolean.TRUE.equals(this.enabled) && !this.shaclRepo) {
            LOGGER.warn("You have tried to enable SHACL validation, but the underlying repository is not SHACL-enabled! Your mutations cannot be validated!");
        }
        if (!this.isDisabled() && this.shaclRepo) {
            this.notifyListeners(ShaclStatusChangedEvent.enabled(this.schema));
        } else {
            this.notifyListeners(ShaclStatusChangedEvent.disabled());
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException(String.format("%s not initialized. Call %1$s.initialize() method.", this.getClass().getSimpleName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reloadSchema(ShaclSchema newShacl) {
        block17: {
            newShacl.setEnabledAtTransactionLevel(this.initialShaclMode);
            newShacl.setOperatingInCluster(this.clustered);
            if (this.isDisabled()) {
                this.notifyListeners(ShaclStatusChangedEvent.disabled());
                return;
            }
            this.checkInitialized();
            Repository repo = this.getRepository();
            ShaclStatusChangedEvent changedEvent = ShaclStatusChangedEvent.disabled();
            try (RepositoryConnection connection = repo.getConnection();){
                try {
                    if (this.isWritable(connection)) {
                        this.performValidatingTransaction(newShacl, connection, false);
                        changedEvent = ShaclStatusChangedEvent.enabled(newShacl);
                        LOGGER.info("Reloaded SHACL.");
                    } else {
                        LOGGER.warn("Repository not writable. Proceeding without SHACL!");
                    }
                }
                catch (IOException ioe) {
                    throw new InvalidSchemaException("Cannot instantiate SHACL schema!");
                }
                catch (RepositoryException re) {
                    if (DIRECT_UPDATES_EXCEPTION.equals(re.getMessage())) {
                        LOGGER.warn("Trying to update a worker repository directly. Proceeding without SHACL!");
                        break block17;
                    }
                    if (this.isShaclError(re)) {
                        this.parseValidationReport(newShacl, connection, re);
                        break block17;
                    }
                    throw new ShaclBindException(String.format("Could not bind SHACL due to: '%s'.", re.getMessage()), ErrorCode.COULD_NOT_BIND_SHACL);
                }
            }
            finally {
                this.notifyListeners(changedEvent);
            }
        }
        this.schema = newShacl;
    }

    private boolean isWritable(RepositoryConnection connection) {
        if (!connection.getRepository().isWritable()) {
            try {
                connection.begin();
                connection.rollback();
                return true;
            }
            catch (RuntimeException re) {
                return false;
            }
        }
        return true;
    }

    private boolean isShaclError(RepositoryException re) {
        return re.getMessage().contains(SHACL_FAILED_VALIDATION) || re.getCause() instanceof ValidationException;
    }

    public synchronized void revalidate(ShaclSchema schema) {
        if (this.isDisabled()) {
            return;
        }
        this.checkInitialized();
        Repository repo = this.getRepository();
        try (RepositoryConnection connection = repo.getConnection();){
            this.timeAndPerformShaclValidation(schema, connection);
        }
        catch (IOException | RepositoryException exception) {
            throw new ShaclBindException(String.format("Could not revalidate due to: '%s'", exception.getMessage()), ErrorCode.UNHANDLED_RUNTIME);
        }
    }

    private void timeAndPerformShaclValidation(ShaclSchema schema, RepositoryConnection connection) throws IOException {
        try {
            long start = System.currentTimeMillis();
            this.performValidatingTransaction(null, connection, true);
            LOGGER.info("Validated data with SHACL in {} ms.", (Object)(System.currentTimeMillis() - start));
        }
        catch (RepositoryException re) {
            if (this.isShaclError(re)) {
                this.parseValidationReport(schema, connection, re);
            }
            throw re;
        }
    }

    private boolean isDisabled() {
        return StringUtils.isBlank((CharSequence)this.endpoint.getAddress()) || StringUtils.isBlank((CharSequence)this.endpoint.getRepository()) || Boolean.FALSE.equals(this.enabled);
    }

    private void performValidatingTransaction(ShaclSchema newShacl, RepositoryConnection connection, boolean revalidation) throws IOException {
        ShaclSail.TransactionSettings.ValidationApproach approach = ShaclSail.TransactionSettings.ValidationApproach.Auto;
        if (revalidation) {
            approach = ShaclSail.TransactionSettings.ValidationApproach.Bulk;
        } else if (Boolean.FALSE.equals(newShacl.isEnabledAtTransactionLevel())) {
            approach = ShaclSail.TransactionSettings.ValidationApproach.Disabled;
        }
        if (approach == ShaclSail.TransactionSettings.ValidationApproach.Auto) {
            connection.begin(new TransactionSetting[]{approach, IsolationLevels.READ_COMMITTED});
        } else {
            connection.begin(new TransactionSetting[]{approach});
        }
        if (!revalidation) {
            connection.clear(new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});
            String shaclSchema = newShacl.toTurtle();
            LOGGER.info("Removing old SHACL schema");
            LOGGER.debug("Deploying SHACL schema:\n{}", (Object)shaclSchema);
            connection.add((Reader)new StringReader(shaclSchema), "", RDFFormat.TURTLE, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});
        }
        connection.commit();
    }

    private void parseValidationReport(ShaclSchema schema, RepositoryConnection connection, RepositoryException re) {
        List errors = re.getCause() instanceof ValidationException ? this.validationParser.parse((ValidationException)re.getCause(), schema) : this.validationParser.parse(re.getMessage(), schema);
        ArrayList<ShaclConstraintViolation> clusterMismatchedConstraints = new ArrayList<ShaclConstraintViolation>();
        Function typeResolver = this.validationParser.createShaclTypeResolver(this.fetchShaclProperties(connection));
        errors.stream().filter(ShaclConstraintViolation::needsParsing).forEach(this.fetchActualViolation(typeResolver, schema, clusterMismatchedConstraints));
        this.validationParser.processClusterMismatches(errors, clusterMismatchedConstraints, schema);
        OperationResponse opResp = new OperationResponse();
        errors.forEach(constraint -> opResp.addError(constraint.toString()));
        if (this.isClusterDeployment()) {
            opResp.addWarningMessage((Serializable)((Object)"SHACL errors upon schema bind cannot be fully reported in cluster mode!"));
        }
        throw new ShaclValidationException("SHACL bind failed due to invalid data!", opResp);
    }

    private List<Statement> fetchShaclProperties(RepositoryConnection connection) {
        try (RepositoryResult statements = connection.getStatements(null, SHACL.PROPERTY, null, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});){
            List<Statement> list = statements.stream().collect(Collectors.toList());
            return list;
        }
    }

    private Consumer<ShaclConstraintViolation> fetchActualViolation(Function<ShaclConstraintViolation, Resource> typeRosolver, ShaclSchema shacl, List<ShaclConstraintViolation> clusterMismatchedConstraints) {
        return constraint -> {
            Resource violation = (Resource)typeRosolver.apply((ShaclConstraintViolation)constraint);
            if (null != violation) {
                constraint.setSemanticObject(shacl.getPrefixes().toName(violation.stringValue()));
                constraint.parseTargetValue(shacl);
            } else {
                clusterMismatchedConstraints.add((ShaclConstraintViolation)constraint);
            }
        };
    }

    @NotNull
    private Repository getRepository() {
        return this.factory.getRepository(this.endpoint);
    }

    public synchronized void clear() {
        this.checkInitialized();
        if (StringUtils.isBlank((CharSequence)this.endpoint.getAddress()) || StringUtils.isBlank((CharSequence)this.endpoint.getRepository()) || !this.checkShaclEnabledForRepository() || Boolean.FALSE.equals(this.enabled)) {
            this.notifyListeners(ShaclStatusChangedEvent.disabled());
            return;
        }
        try (RepositoryConnection connection = this.getRepository().getConnection();){
            if (this.isWritable(connection)) {
                connection.begin();
                connection.clear(new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});
                connection.commit();
                this.notifyListeners(ShaclStatusChangedEvent.disabled());
                LOGGER.info("Cleared old SHACL.");
            } else {
                LOGGER.warn("Repository not writable. Cannot clear old SHACL!");
            }
        }
        catch (RuntimeException re) {
            if (DIRECT_UPDATES_EXCEPTION.equals(re.getMessage())) {
                LOGGER.warn("Trying to update a worker repository directly. Cannot clear old SHACL!");
            }
            throw new ShaclBindException(String.format("Could not clear old SHACL due to: '%s'.", re.getMessage()), ErrorCode.COULD_NOT_CLEAR_SHACL);
        }
    }

    public boolean checkShaclEnabledForRepository() {
        return this.checkShaclEnabledForRepository(false);
    }

    private boolean checkShaclEnabledForRepository(boolean startupCheck) {
        if (!this.isClusterDeployment()) {
            boolean bl;
            block10: {
                CloseableHttpClient httpClient = this.getHttpClient();
                try {
                    LinkedHashMap<String, Boolean> successMapping = new LinkedHashMap<String, Boolean>();
                    for (String address : HttpUtils.getAddresses(this.endpoint)) {
                        Boolean checkResponse = this.checkEndpoint(httpClient, address, startupCheck);
                        successMapping.put(address, checkResponse);
                    }
                    bl = this.reportShaclCheck(successMapping, startupCheck);
                    if (httpClient == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (httpClient != null) {
                            try {
                                httpClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException io) {
                        throw this.createNetworkException(this.endpoint.getAddress(), "Could not check if SHACL is enabled: " + io.getMessage());
                    }
                }
                httpClient.close();
            }
            return bl;
        }
        return this.isEnabled();
    }

    private boolean reportShaclCheck(Map<String, Boolean> responseMapping, boolean startupCheck) {
        boolean singleNode;
        boolean bl = singleNode = responseMapping.size() == 1;
        if (singleNode) {
            return this.reportSingleEndpoint(responseMapping, startupCheck);
        }
        List inaccessible = responseMapping.entrySet().stream().filter(entry -> entry.getValue() == null).map(entry -> Protocol.getRepositoryLocation((String)((String)entry.getKey()), (String)this.endpoint.getRepository())).collect(Collectors.toList());
        List enabledAddresses = responseMapping.entrySet().stream().filter(entry -> Boolean.TRUE.equals(entry.getValue())).map(entry -> Protocol.getRepositoryLocation((String)((String)entry.getKey()), (String)this.endpoint.getRepository())).collect(Collectors.toList());
        List disabledAddresses = responseMapping.entrySet().stream().filter(entry -> Boolean.FALSE.equals(entry.getValue())).map(entry -> Protocol.getRepositoryLocation((String)((String)entry.getKey()), (String)this.endpoint.getRepository())).collect(Collectors.toList());
        if (!inaccessible.isEmpty()) {
            LOGGER.warn("Could not connect to following endpoints: {}", inaccessible);
        }
        if (enabledAddresses.isEmpty() && disabledAddresses.isEmpty()) {
            if (startupCheck) {
                LOGGER.warn("Could not determine the SHACL status for {}", inaccessible);
                return this.isEnabled();
            }
            throw this.createNetworkException(inaccessible.toString(), "No accessible endpoints");
        }
        if (enabledAddresses.isEmpty()) {
            LOGGER.debug("SHACL support is disabled");
            return false;
        }
        if (disabledAddresses.isEmpty()) {
            LOGGER.debug("SHACL support is enabled");
            return true;
        }
        LOGGER.warn("SHACL enabled for {} and disabled for {}", enabledAddresses, disabledAddresses);
        return this.isEnabled();
    }

    private boolean reportSingleEndpoint(Map<String, Boolean> responseMapping, boolean startupCheck) {
        Map.Entry<String, Boolean> entry = responseMapping.entrySet().iterator().next();
        String address = entry.getKey();
        Boolean result = entry.getValue();
        if (result == null) {
            if (startupCheck) {
                LOGGER.warn("Could not determine the SHACL status for {}/{}", (Object)address, (Object)this.endpoint.getRepository());
                return this.isEnabled();
            }
            throw this.createNetworkException(address, "Could not report endpoint status");
        }
        LOGGER.debug("Detected SHACL for {}/{} is {}", new Object[]{address, this.endpoint.getRepository(), Boolean.TRUE.equals(result) ? "enabled" : "disabled"});
        return result;
    }

    @NotNull
    private PlatformConfigurationException createNetworkException(String address, String reason) {
        return new PlatformConfigurationException(String.format("Could not connect to %s, check network settings: %s", address, reason), ErrorCode.BAD_CONFIG_GRAPHDB_UNREACHABLE);
    }

    private Boolean checkEndpoint(CloseableHttpClient httpClient, String address, boolean startupCheck) {
        try {
            HttpUriRequest repositoryConfigRequest = HttpUtils.newHttpRequest(address, this.endpoint);
            CloseableHttpResponse response = httpClient.execute(repositoryConfigRequest);
            if (this.checkResponseStatus((HttpResponse)response, startupCheck)) {
                return this.isEnabled();
            }
            JSONObject jsonObject = new JSONObject(ShaclManager.getResponseAsString((HttpResponse)response));
            this.clustered = ShaclManager.isConnectedToCluster(jsonObject);
            if (this.isClusterDeployment()) {
                if (this.schema != null) {
                    this.schema.setOperatingInCluster(Boolean.valueOf(true));
                }
                LOGGER.warn("Problem while checking SHACL support: cannot detect if all workers in a  cluster support SHACL! Defaulting to the configuration value for validation.shacl.enabled: {}.", (Object)this.isEnabled());
                return this.isEnabled();
            }
            return jsonObject.getJSONObject("params").getJSONObject("isShacl").getBoolean("value");
        }
        catch (IOException io) {
            if (startupCheck) {
                return this.isEnabled();
            }
            LOGGER.warn("Could not access remote endpoint '{}' to check the SHACL support due to: {}", (Object)address, (Object)io.getMessage());
            return null;
        }
        catch (URISyntaxException use) {
            throw new InvalidConfigurationException(use.getMessage(), ErrorCode.BAD_CONFIG_INVALID_GRAPHDB_ADDRESS);
        }
        catch (JSONException je) {
            LOGGER.error("Unexpected response from {}. SHACL support will be disabled!", (Object)address, (Object)je);
            return false;
        }
    }

    private boolean isClusterDeployment() {
        return Boolean.TRUE.equals(this.clustered);
    }

    private boolean checkResponseStatus(HttpResponse response, boolean startupCheck) throws IOException {
        PlatformConfigurationException breakingPce = HttpUtils.checkRepositoryResponseValidity(response, this.getRepositoryAddress());
        if (null != breakingPce) {
            if (startupCheck) {
                LOGGER.warn("Could not determine SHACL support for repository '{}', due to: {}", (Object)this.endpoint.getRepository(), (Object)breakingPce.getMessage());
                return true;
            }
            throw breakingPce;
        }
        return false;
    }

    @NotNull
    private CloseableHttpClient getHttpClient() {
        return HttpUtils.buildClient(this.endpoint).setDefaultHeaders(null).build();
    }

    private static String getResponseAsString(HttpResponse response) throws IOException {
        try (InputStream content = response.getEntity().getContent();){
            String string = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private static boolean isConnectedToCluster(JSONObject jsonObject) {
        return !jsonObject.isNull("type") && "master".equals(jsonObject.getString("type"));
    }

    public void setEndpoint(SparqlEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setFactory(SparqlConnectionFactory factory) {
        this.factory = factory;
    }

    public void setValidationParser(ValidationReportParser parser) {
        this.validationParser = parser;
    }

    public String getRepositoryAddress() {
        return String.format("Repository: %s at address %s", this.endpoint.getRepository(), this.endpoint.getAddress());
    }

    public boolean isShaclRepo() {
        return this.shaclRepo;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setShaclRepo(boolean shaclRepo) {
        this.shaclRepo = shaclRepo;
    }

    public void setInitialShaclMode(Boolean enable) {
        this.initialShaclMode = enable;
    }

    public boolean getInitialShaclMode() {
        return this.initialShaclMode;
    }

    public void addListener(ShaclChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ShaclChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(ShaclStatusChangedEvent event) {
        for (ShaclChangedListener listener : this.listeners) {
            listener.onShaclChangeEvent(event);
        }
    }
}

