/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.ValueReader;
import com.ontotext.sparql.Rdf4jValueConverter;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

class RdfHandlerToRdfData
extends AbstractRDFHandler {
    private RdfData data;

    RdfHandlerToRdfData() {
    }

    public void startRDF() {
        this.data = EntityPoolFactory.defaultPool().emptyData();
        this.data.setValueReader((ValueReader)Rdf4jValueConverter.INSTANCE);
    }

    public void handleStatement(Statement st) {
        String subject = Rdf4jValueConverter.convert((Value)st.getSubject()).toString();
        String predicate = Rdf4jValueConverter.convert((Value)st.getPredicate()).toString();
        Object convertedObject = st.getObject() instanceof IRI ? st.getObject().stringValue() : st.getObject();
        this.data.add(subject, predicate, convertedObject);
    }

    RdfData getRdfData() {
        return this.data;
    }
}

