/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.sparql.AbstractSparqlRequest;
import com.ontotext.sparql.SparqlConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.rio.RDFHandler;

public class QueryRequest
extends AbstractSparqlRequest<String, QueryRequest> {
    private static final Pattern CONSTRUCT_PATTERN = Pattern.compile("\\b[cC][oO][nN][sS][tT][rR][uU][cC][tT]\\b");
    private static final Pattern BRACKETS_PATTERN = Pattern.compile("[{}]");
    private static final Pattern SELECT_PATTERN = Pattern.compile("\\b[sS][eE][lL][eE][cC][tT]\\b");
    private final String query;
    private final Map<String, List<String>> bindings;
    private final SomlSchema somlSchema;
    private AtomicInteger limit;
    private TupleQueryResultHandler tupleHandler;
    private RDFHandler rdfHandler;

    public QueryRequest(String requestId, String query, Map<String, List<String>> bindings, SomlSchema somlSchema) {
        this(requestId, query, bindings, somlSchema, new AtomicInteger(Integer.MAX_VALUE));
    }

    public QueryRequest(String requestId, String query, Map<String, List<String>> bindings, SomlSchema somlSchema, AtomicInteger limit) {
        super(requestId);
        this.query = query;
        this.bindings = bindings;
        this.somlSchema = somlSchema;
        this.limit = limit;
    }

    public static QueryRequest newSimpleQuery(String query) {
        return QueryRequest.newSimpleQuery(UUID.randomUUID().toString(), query);
    }

    public static QueryRequest newSimpleQuery(String requestId, String query) {
        return new QueryRequest(requestId, query, Collections.emptyMap(), null);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public Map<String, List<String>> getBindings() {
        return this.bindings;
    }

    public SomlSchema getSomlSchema() {
        return this.somlSchema;
    }

    public static boolean isConstruct(String query) {
        return CONSTRUCT_PATTERN.matcher(query).find();
    }

    public static boolean isSelect(String query) {
        Matcher matcher = SELECT_PATTERN.matcher(query);
        if (matcher.find()) {
            return !BRACKETS_PATTERN.matcher(query.substring(0, matcher.start())).find();
        }
        return false;
    }

    public boolean isSparqlPlanRequest() {
        return this.getBindings().containsKey("plan") && this.getBindings().size() == 1;
    }

    public AtomicInteger getLimit() {
        return this.limit;
    }

    @Override
    public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
        if (QueryRequest.isSelect(this.query)) {
            if (this.tupleHandler != null) {
                connection.executeSelect(this, this.tupleHandler);
                return (E)ExecutionResponse.of((Object)this.getRequestId(), (String)this.getRequestId());
            }
            return (E)connection.executeSelect(this);
        }
        if (QueryRequest.isConstruct(this.query)) {
            if (this.rdfHandler != null) {
                connection.executeConstruct(this, this.rdfHandler);
                return (E)ExecutionResponse.of((Object)this.getRequestId(), (String)this.getRequestId());
            }
            return (E)connection.executeConstruct(this);
        }
        throw new UnsupportedOperationException("Only CONSTRUCT and SELECT queries are supported!");
    }

    public QueryRequest setHandler(TupleQueryResultHandler handler) {
        this.tupleHandler = handler;
        return this;
    }

    public QueryRequest setHandler(RDFHandler handler) {
        this.rdfHandler = handler;
        return this;
    }

    public TupleQueryResultHandler getTupleHandler() {
        return this.tupleHandler;
    }

    public RDFHandler getRdfHandler() {
        return this.rdfHandler;
    }
}

