/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.sparql.RepositoryCreator;
import com.ontotext.sparql.SparqlEndpoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.jetbrains.annotations.NotNull;

public class ChainingRepositoryCreator
implements RepositoryCreator {
    private final List<RepositoryCreator> chain;

    public ChainingRepositoryCreator(List<RepositoryCreator> chain) {
        this.chain = new ArrayList<RepositoryCreator>(chain);
    }

    public ChainingRepositoryCreator(RepositoryCreator ... chain) {
        this.chain = Arrays.asList(chain);
    }

    @Override
    @NotNull
    public Repository createRepository(RepositoryManager repositoryManager, SparqlEndpoint endpoint) {
        RepositoryException repositoryException = new RepositoryException("Could not create repository " + String.valueOf(endpoint));
        for (RepositoryCreator creator : this.chain) {
            if (creator == null) continue;
            try {
                return creator.createRepository(repositoryManager, endpoint);
            }
            catch (RuntimeException re) {
                repositoryException.addSuppressed((Throwable)re);
                repositoryManager.refresh();
            }
        }
        throw repositoryException;
    }

    public List<RepositoryCreator> getChain() {
        return this.chain;
    }
}

