/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.AbstractSparqlRequest;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.UpdateRequest;
import com.ontotext.sparql.UpdateResponse;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BulkUpdateRequest
extends AbstractSparqlRequest<String, BulkUpdateRequest> {
    private final List<UpdateRequest> updateRequests;

    public BulkUpdateRequest(String requestId, List<UpdateRequest> updateRequests) {
        super(requestId);
        this.updateRequests = Objects.requireNonNull(updateRequests);
    }

    @Override
    public String getQuery() {
        return "Bulk update request of " + this.updateRequests.size() + " requests";
    }

    @Override
    public void setIncludeInferred(@Nullable Boolean includeInferred) {
        super.setIncludeInferred(includeInferred);
        this.updateRequests.forEach(updateRequest -> updateRequest.setIncludeInferred(includeInferred));
    }

    @Override
    public void setExpandOverSameAs(@Nullable Boolean expandOverSameAs) {
        super.setExpandOverSameAs(expandOverSameAs);
        this.updateRequests.forEach(updateRequest -> updateRequest.setExpandOverSameAs(expandOverSameAs));
    }

    @Override
    public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
        Logger logger = Loggers.sparqlQueryLogger();
        connection.begin();
        try {
            logger.trace("Bulk transaction begin: {}", (Object)this.getRequestId());
            for (UpdateRequest updateRequest : this.updateRequests) {
                if (!this.logRequest()) {
                    updateRequest.disableRequestLogging();
                }
                updateRequest.execute(connection);
            }
            logger.trace("Bulk transaction commit: {}", (Object)this.getRequestId());
            connection.commit();
        }
        catch (RuntimeException ex) {
            logger.trace("Bulk transaction rollback: {}", (Object)this.getRequestId());
            connection.rollback();
            throw ex;
        }
        return (E)new UpdateResponse(this.getRequestId(), null, null);
    }

    @Override
    public BulkUpdateRequest disableRequestLogging() {
        super.disableRequestLogging();
        this.updateRequests.forEach(AbstractSparqlRequest::disableRequestLogging);
        return this;
    }
}

