/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.sparql.AbstractSparqlRequest;
import com.ontotext.sparql.SparqlConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class AskRequest
extends AbstractSparqlRequest<String, AskRequest> {
    private static final Pattern ASK_PATTERN = Pattern.compile("\\b[aA][sS][kK]\\b");
    private final String query;
    private final Map<String, List<String>> bindings;

    public AskRequest(String requestId, String query, Map<String, List<String>> bindings) {
        super(requestId);
        this.query = query;
        this.bindings = bindings;
    }

    public static AskRequest newSimpleQuery(String query) {
        return AskRequest.newSimpleQuery(UUID.randomUUID().toString(), query);
    }

    public static AskRequest newSimpleQuery(String requestId, String query) {
        return new AskRequest(requestId, query, Collections.emptyMap());
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public Map<String, List<String>> getBindings() {
        return this.bindings;
    }

    @Override
    public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
        if (AskRequest.isAskQuery(this.query)) {
            return (E)connection.executeAsk(this);
        }
        throw new UnsupportedOperationException("Only ASK queries are supported!");
    }

    private static boolean isAskQuery(String query) {
        return query != null && ASK_PATTERN.matcher(query).find();
    }
}

