/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.Debounce;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.Resettable;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.sparql.AskRequest;
import com.ontotext.sparql.BooleanResponse;
import com.ontotext.sparql.DelegatingSparqlConnection;
import com.ontotext.sparql.InterruptedQueryException;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.Rdf4jSparqlConnection;
import com.ontotext.sparql.RepositoryCreator;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.sparql.SparqlResponse;
import com.ontotext.sparql.UpdateRequest;
import com.ontotext.sparql.UpdateResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class AbstractSparqlConnectionFactory
implements SparqlConnectionFactory,
Resettable {
    private Map<String, ManagerEntry> managers = new ConcurrentHashMap<String, ManagerEntry>();
    private Map<String, Debounce<HealthResult>> readHealthCache = new ConcurrentHashMap<String, Debounce<HealthResult>>();
    private RepositoryCreator repositoryCreator = RepositoryCreator.DEFAULT;

    @Override
    public SparqlConnection getConnection(SparqlEndpoint info) {
        Rdf4jSparqlConnection connection = this.getRdf4jSparqlConnection(info);
        return new RecoverableSparqlConnection(connection, info);
    }

    @NotNull
    private Rdf4jSparqlConnection getRdf4jSparqlConnection(SparqlEndpoint info) {
        Repository repository = this.getRepository(info);
        RepositoryConnection repositoryConnection = this.getRepositoryConnection(repository, info);
        Rdf4jSparqlConnection connection = new Rdf4jSparqlConnection(repositoryConnection, info);
        if (info.getSubqueryFullResult() != null) {
            connection.setInterpolateTupleResults(info.getSubqueryFullResult() == false);
        }
        connection.setEnableCartesianProtection(info.isCartesianProtectionEnabled());
        return connection;
    }

    protected RepositoryConnection getRepositoryConnection(Repository repository, SparqlEndpoint info) {
        return repository.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository getRepository(SparqlEndpoint info) {
        Repository repository;
        RepositoryManager manager;
        ManagerEntry managerEntry = this.getOrCreateRepositoryManager(info);
        Lock repositoryAcquireLock = managerEntry.getLock();
        try {
            if (!repositoryAcquireLock.tryLock(2L, TimeUnit.SECONDS)) {
                throw AbstractSparqlConnectionFactory.couldNotGetRepo();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new InterruptedQueryException("Could not acquire access to repository: " + info.getRepository());
        }
        try {
            manager = managerEntry.getManager();
            repository = manager.getRepository(info.getRepository());
        }
        finally {
            repositoryAcquireLock.unlock();
        }
        if (repository == null) {
            this.getLogger().debug("Repository {} does not exists, trying to create it!", (Object)info);
            repository = this.getRepositoryCreator().createRepository(manager, info);
            this.getLogger().info("Successfully created repository: {}", (Object)info);
        }
        return repository;
    }

    @NotNull
    private static RepositoryException couldNotGetRepo() {
        return new RepositoryException(String.format("Error code %d: Could not access repository in time", ErrorCode.COULD_NOT_CONNECT_TO_ENDPOINT.getCode()));
    }

    @Override
    public void setRepositoryCreator(RepositoryCreator creator) {
        this.repositoryCreator = (RepositoryCreator)ObjectsUtil.getOrDefault((Object)creator, (Object)RepositoryCreator.DEFAULT);
    }

    @Override
    @NotNull
    public RepositoryCreator getRepositoryCreator() {
        return this.repositoryCreator;
    }

    private ManagerEntry getOrCreateRepositoryManager(SparqlEndpoint endpoint) {
        return this.managers.computeIfAbsent(this.getRepositoryKey(endpoint), key -> new ManagerEntry(endpoint));
    }

    protected String getRepositoryKey(SparqlEndpoint endpoint) {
        return endpoint.getAddress() + endpoint.getRepository() + endpoint.getUsername() + endpoint.getCredentials() + endpoint.getConnectionInfo();
    }

    protected abstract RepositoryManager createRepositoryManager(SparqlEndpoint var1);

    protected abstract Logger getLogger();

    @Override
    public void close() {
        this.managers.values().forEach(ManagerEntry::shutDown);
        this.reset();
    }

    public void reset() {
        this.managers.clear();
        this.readHealthCache.clear();
    }

    @Override
    public HealthResult checkHealth(SparqlEndpoint endpoint) {
        if (endpoint == null) {
            return HealthResult.red(null, (String)"Null endpoint!");
        }
        String name = endpoint.toString();
        return ((HealthResult)this.readHealthCache.computeIfAbsent(name, key -> new Debounce((long)endpoint.getHealthCacheTimeout())).get(() -> this.getHealthResult(endpoint))).copy();
    }

    @NotNull
    private HealthResult getHealthResult(SparqlEndpoint endpoint) {
        SparqlConnection connection;
        Repository repository;
        String name = endpoint.toString();
        try {
            repository = this.getRepository(endpoint);
            if (repository == null) {
                return HealthResult.red((String)name, (String)("No repository: " + endpoint.getRepository()));
            }
        }
        catch (PlatformConfigurationException pce) {
            return HealthResult.red((String)name, (String)("No repository: " + endpoint.getRepository()), (Throwable)pce);
        }
        catch (UnauthorizedException ue) {
            this.getLogger().debug("Could not check if repository exists at {} due to unauthorized error", (Object)name, (Object)ue);
            return HealthResult.red((String)name, (String)("Could not authenticate at: " + name), (Throwable)ue);
        }
        catch (Exception ex) {
            this.getLogger().debug("Could not check if repository exists at {} due to error", (Object)name, (Object)ex);
            return HealthResult.red((String)name, (String)("Could not connect to: " + name), (Throwable)ex);
        }
        try {
            connection = this.getConnection(endpoint);
            try {
                connection.executeAsk((AskRequest)AskRequest.newSimpleQuery("ASK { FILTER(true) }").disableRequestLogging());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().debug("Could not query {} due to error", (Object)name, (Object)ex);
            if (this.isConnectionException(ex)) {
                return HealthResult.red((String)name, (String)("Could not connect to: " + name), (Throwable)ex);
            }
            return HealthResult.red((String)endpoint.toString(), (String)SparqlUtil.getExceptionMessage((Throwable)ex), (Throwable)ex);
        }
        try {
            connection = repository.getConnection();
            try {
                connection.begin();
                connection.rollback();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().debug("Could not write to {} due to error", (Object)name, (Object)ex);
            return HealthResult.yellow((String)endpoint.toString(), (String)SparqlUtil.getExceptionMessage((Throwable)ex));
        }
        return HealthResult.green((String)endpoint.toString());
    }

    private boolean isConnectionException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        if (ex instanceof SocketTimeoutException || ex instanceof SocketException) {
            return true;
        }
        return this.isConnectionException(ex.getCause());
    }

    @Override
    public void reload(SparqlEndpoint endpoint) {
        this.getLogger().info("Reloading information for repository: {}", (Object)endpoint);
        this.getOrCreateRepositoryManager(endpoint).getManager().refresh();
    }

    private class RecoverableSparqlConnection
    extends DelegatingSparqlConnection {
        private final SparqlEndpoint endpoint;

        private RecoverableSparqlConnection(SparqlConnection delegate, SparqlEndpoint endpoint) {
            super(delegate);
            this.endpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SparqlResponse executeConstruct(QueryRequest queryRequest) {
            String oldValue = SparqlEndpointRequestContext.getRepository();
            try {
                SparqlEndpointRequestContext.setRepository(this.endpoint.getRepository());
                SparqlResponse sparqlResponse = this.delegate.executeConstruct(queryRequest);
                return sparqlResponse;
            }
            finally {
                SparqlEndpointRequestContext.setRepository(oldValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeConstruct(QueryRequest queryRequest, RDFHandler handler) {
            String oldValue = SparqlEndpointRequestContext.getRepository();
            try {
                SparqlEndpointRequestContext.setRepository(this.endpoint.getRepository());
                this.delegate.executeConstruct(queryRequest, handler);
            }
            finally {
                SparqlEndpointRequestContext.setRepository(oldValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SparqlResponse executeSelect(QueryRequest queryRequest) {
            String oldValue = SparqlEndpointRequestContext.getRepository();
            try {
                SparqlEndpointRequestContext.setRepository(this.endpoint.getRepository());
                SparqlResponse sparqlResponse = this.delegate.executeSelect(queryRequest);
                return sparqlResponse;
            }
            finally {
                SparqlEndpointRequestContext.setRepository(oldValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeSelect(QueryRequest queryRequest, TupleQueryResultHandler resultHandler) {
            String oldValue = SparqlEndpointRequestContext.getRepository();
            try {
                SparqlEndpointRequestContext.setRepository(this.endpoint.getRepository());
                this.delegate.executeSelect(queryRequest, resultHandler);
            }
            finally {
                SparqlEndpointRequestContext.setRepository(oldValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UpdateResponse executeUpdate(UpdateRequest updateRequest) {
            String oldValue = SparqlEndpointRequestContext.getRepository();
            try {
                SparqlEndpointRequestContext.setRepository(this.endpoint.getRepository());
                UpdateResponse updateResponse = this.delegate.executeUpdate(updateRequest);
                return updateResponse;
            }
            finally {
                SparqlEndpointRequestContext.setRepository(oldValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BooleanResponse executeAsk(AskRequest askRequest) {
            String oldValue = SparqlEndpointRequestContext.getRepository();
            try {
                SparqlEndpointRequestContext.setRepository(this.endpoint.getRepository());
                BooleanResponse booleanResponse = this.delegate.executeAsk(askRequest);
                return booleanResponse;
            }
            finally {
                SparqlEndpointRequestContext.setRepository(oldValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(InputStream inputStream, String baseUri, RDFFormat rdfFormat, Resource ... contexts) throws IOException {
            String oldValue = SparqlEndpointRequestContext.getRepository();
            try {
                SparqlEndpointRequestContext.setRepository(this.endpoint.getRepository());
                this.delegate.add(inputStream, baseUri, rdfFormat, contexts);
            }
            finally {
                SparqlEndpointRequestContext.setRepository(oldValue);
            }
        }

        @Override
        public List<Namespace> getNamespaces() {
            String oldValue = SparqlEndpointRequestContext.getRepository();
            try {
                SparqlEndpointRequestContext.setRepository(this.endpoint.getRepository());
                List<Namespace> list = this.delegate.getNamespaces();
                return list;
            }
            finally {
                SparqlEndpointRequestContext.setRepository(oldValue);
            }
        }

        @Override
        public void setNamespace(String prefix, String namespace) {
            this.delegate.setNamespace(prefix, namespace);
        }

        @Override
        public void begin() {
            try {
                this.delegate.begin();
            }
            catch (RepositoryException re) {
                if (this.isApplicableForReload(re)) {
                    this.reloadDelegate();
                    this.delegate.begin();
                }
                throw re;
            }
        }

        @Override
        public void begin(String isolationLevel) {
            try {
                this.delegate.begin(isolationLevel);
            }
            catch (RepositoryException re) {
                if (this.isApplicableForReload(re)) {
                    this.reloadDelegate();
                    this.delegate.begin(isolationLevel);
                }
                throw re;
            }
        }

        private boolean isApplicableForReload(RepositoryException re) {
            return re.getMessage() != null && re.getMessage().endsWith("HTTP error code 404");
        }

        private void reloadDelegate() {
            AbstractSparqlConnectionFactory.this.reload(this.endpoint);
            this.delegate = AbstractSparqlConnectionFactory.this.getRdf4jSparqlConnection(this.endpoint);
        }
    }

    private class ManagerEntry {
        private final SparqlEndpoint sparqlEndpoint;
        private final Lock lock = new ReentrantLock();
        private RepositoryManager manager;

        private ManagerEntry(SparqlEndpoint endpoint) {
            this.sparqlEndpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RepositoryManager getManager() {
            if (this.manager == null) {
                ManagerEntry managerEntry = this;
                synchronized (managerEntry) {
                    this.manager = AbstractSparqlConnectionFactory.this.createRepositoryManager(this.sparqlEndpoint);
                }
            }
            return this.manager;
        }

        public Lock getLock() {
            return this.lock;
        }

        public void shutDown() {
            this.getManager().shutDown();
        }
    }
}

