/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.repository.http;

import com.ontotext.repository.http.PlatformServiceUnavailableRetryStrategy;
import com.ontotext.repository.http.RetryHandlerStale;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.logging.LoggingContext;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUtils {
    private static final String SEPARATOR_PATTERN = "\\s*[,;]\\s*";
    static final HttpRequestRetryHandler RETRY_HANDLER_STALE = new RetryHandlerStale();

    private HttpUtils() {
    }

    public static List<String> getAddresses(SparqlEndpoint endpoint) {
        String address = endpoint.getAddress();
        if (address == null) {
            return Collections.emptyList();
        }
        return HttpUtils.splitBySeparator(address).collect(Collectors.toList());
    }

    @NotNull
    private static Stream<String> splitBySeparator(String address) {
        return Arrays.stream(address.split(SEPARATOR_PATTERN)).map(StringUtils::trimToNull).filter(Objects::nonNull);
    }

    public static boolean isMultiAddressEndpoint(SparqlEndpoint endpoint) {
        return HttpUtils.getAddresses(endpoint).size() > 1;
    }

    public static String getFirstRepositoryAddress(SparqlEndpoint endpoint) {
        List<String> addresses = HttpUtils.getAddresses(endpoint);
        if (addresses.isEmpty()) {
            return null;
        }
        return addresses.get(0);
    }

    public static HttpClientBuilder buildClient(SparqlEndpoint endpoint) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        HttpUtils.setupClient(clientBuilder, endpoint);
        return clientBuilder;
    }

    public static void setupClient(HttpClientBuilder clientBuilder, SparqlEndpoint endpoint) {
        PlatformServiceUnavailableRetryStrategy unavailableRetryStrategy = null;
        if (endpoint.getMaxRetries() > 0 && endpoint.getRetryInterval() > 0) {
            unavailableRetryStrategy = new PlatformServiceUnavailableRetryStrategy(endpoint.getMaxRetries(), endpoint.getRetryInterval(), HttpUtils.parseRetryCodes(endpoint.getRetryHttpCodes()));
        }
        clientBuilder.evictExpiredConnections().addInterceptorLast(HttpUtils.copyRequestHeaders()).setDefaultHeaders(endpoint.getHeaders()).setMaxConnPerRoute(endpoint.getMaxConcurrentConnections()).setMaxConnTotal(endpoint.getMaxConcurrentConnections()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(endpoint.getConnectTimeout()).setSocketTimeout(endpoint.getSocketTimeout()).setConnectionRequestTimeout(endpoint.getConnectionRequestTimeout()).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(endpoint.getSocketTimeout()).build()).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)unavailableRetryStrategy).setRetryHandler(RETRY_HANDLER_STALE);
    }

    public static String getResponseAsString(HttpResponse response) throws IOException {
        try (InputStream content = response.getEntity().getContent();){
            String string = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public static List<Range<Integer>> parseRetryCodes(String httpCodes) {
        if (httpCodes == null) {
            return Collections.emptyList();
        }
        return HttpUtils.splitBySeparator(httpCodes).map(HttpUtils.stringToRange()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private static Function<String, Range<Integer>> stringToRange() {
        return value -> {
            if (value.length() != 3) {
                throw new IllegalArgumentException("HTTP status code out of range: " + value);
            }
            try {
                return Range.is((Comparable)Integer.valueOf(value));
            }
            catch (NumberFormatException nfe) {
                return HttpUtils.parseHttpCode(value);
            }
        };
    }

    @NotNull
    private static Range<Integer> parseHttpCode(String value) {
        char first = value.charAt(0);
        char second = value.charAt(1);
        char third = value.charAt(2);
        if (!Character.isDigit(first)) {
            throw new IllegalArgumentException(String.format("Invalid HTTP code or pattern: %s. It must begin with a number, but found: %s", value, Character.valueOf(first)));
        }
        int hundreds = Integer.parseInt("" + first) * 100;
        if (second == 'x') {
            if (third == 'x') {
                return Range.between((Comparable)Integer.valueOf(hundreds), (Comparable)Integer.valueOf(hundreds + 99));
            }
            throw new IllegalArgumentException("Invalid HTTP range: " + value + ". It must end with an 'x' but found '" + third + "'");
        }
        int decimals = Integer.parseInt("" + second) * 10;
        if (third == 'x') {
            return Range.between((Comparable)Integer.valueOf(hundreds + decimals), (Comparable)Integer.valueOf(hundreds + decimals + 9));
        }
        throw new IllegalArgumentException("Invalid HTTP code or range: " + value);
    }

    public static HttpRequestInterceptor copyRequestHeaders() {
        return (httpRequest, httpContext) -> {
            String requestId = LoggingContext.getRequestId();
            if (requestId != null) {
                httpRequest.setHeader("X-Request-ID", requestId);
            }
            if (SparqlEndpointRequestContext.isSubQueryMode()) {
                httpRequest.setHeader("X-GraphDB-SplitQuery", "true");
                Integer maxTupleResults = SparqlEndpointRequestContext.getSubQueryResultLimit();
                if (maxTupleResults != null) {
                    httpRequest.setHeader("X-GraphDB-SplitQueryLimit", maxTupleResults.toString());
                }
                SparqlEndpointRequestContext.isSubQueryFullResultRequest().ifPresent(value -> httpRequest.setHeader("X-GraphDB-SplitQueryFullResult", "" + value));
            }
            SparqlEndpointRequestContext.getPassthroughHeaders().ifPresent(headers -> {
                for (Pair headerPair : headers) {
                    if (((String)headerPair.getKey()).equals("Authorization")) {
                        httpRequest.setHeader((String)headerPair.getKey(), (String)headerPair.getValue());
                        continue;
                    }
                    httpRequest.addHeader((String)headerPair.getKey(), (String)headerPair.getValue());
                }
            });
        };
    }

    public static HttpUriRequest newHttpRequest(String address, SparqlEndpoint endpoint) throws URISyntaxException {
        HttpUriRequest repositoryConfigRequest = RequestBuilder.get((URI)HttpUtils.getRepositoryUri(address, endpoint)).addHeader("Accept", "application/json").build();
        if (StringUtils.isNotBlank((CharSequence)endpoint.getUsername()) && StringUtils.isNotBlank((CharSequence)endpoint.getCredentials())) {
            String encodedAuthorisation = Base64.getEncoder().encodeToString((endpoint.getUsername() + ":" + endpoint.getCredentials()).getBytes());
            repositoryConfigRequest.addHeader("Authorization", "Basic " + encodedAuthorisation);
        }
        return repositoryConfigRequest;
    }

    private static URI getRepositoryUri(String address, SparqlEndpoint endpoint) throws URISyntaxException {
        address = StringUtils.removeEnd((String)address, (String)"/");
        return new URI(String.format("%s/rest/repositories/%s", address, endpoint.getRepository()));
    }

    @Nullable
    public static PlatformConfigurationException checkRepositoryResponseValidity(HttpResponse response, String repositoryAddress) throws IOException {
        int responseCode = response.getStatusLine().getStatusCode();
        PlatformConfigurationException breakingPce = null;
        if (responseCode == 401 || responseCode == 403) {
            breakingPce = new PlatformConfigurationException("Missing valid authorization credentials!", ErrorCode.OPERATION_FORBIDDEN);
        }
        if (breakingPce == null && responseCode == 404) {
            breakingPce = new PlatformConfigurationException(String.format("Cannot find SPARQL repository at address %s", repositoryAddress), ErrorCode.BAD_CONFIG_REPOSITORY_NOT_FOUND);
        }
        if (breakingPce == null && (responseCode < 200 || responseCode > 299)) {
            breakingPce = new PlatformConfigurationException(String.format("Unhandled exception while trying to check repository support: %s", HttpUtils.getResponseAsString(response)), ErrorCode.UNHANDLED_RUNTIME);
        }
        return breakingPce;
    }
}

