/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.spec.sqlparser.SelectQueryParser;
import it.unibz.inf.ontop.spec.sqlparser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import net.sf.jsqlparser.JSQLParserException;

public class SQLQueryParser {
    private final CoreSingletons coreSingletons;
    private final TermFactory termFactory;

    @Inject
    public SQLQueryParser(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.termFactory = coreSingletons.getTermFactory();
    }

    public RAExpression getRAExpression(String sourceQuery, MetadataLookup metadataLookup) throws InvalidQueryException, MetadataExtractionException {
        SelectQueryParser sqp = new SelectQueryParser(metadataLookup, this.coreSingletons);
        try {
            return sqp.parse(sourceQuery);
        }
        catch (UnsupportedSelectQueryException | JSQLParserException e) {
            RelationDefinition view = metadataLookup.getBlackBoxView(sourceQuery);
            return sqp.translateParserView(view);
        }
    }

    public IQTree convert(RAExpression re) {
        ImmutableList<ExtensionalDataNode> children = re.getDataAtoms();
        Optional joiningConditions = this.termFactory.getConjunction(re.getFilterAtoms().stream());
        IntermediateQueryFactory iqFactory = this.coreSingletons.getIQFactory();
        switch (children.size()) {
            case 0: {
                return iqFactory.createTrueNode();
            }
            case 1: {
                return joiningConditions.map(c -> iqFactory.createUnaryIQTree((UnaryOperatorNode)iqFactory.createFilterNode(c), (IQTree)children.get(0))).orElseGet(() -> (IQTree)children.get(0));
            }
        }
        return iqFactory.createNaryIQTree((NaryOperatorNode)iqFactory.createInnerJoinNode(joiningConditions), (ImmutableList)children.stream().collect(ImmutableCollectors.toList()));
    }
}

