/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributeOccurrences;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class RAExpressionAttributes {
    private final ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes;
    private final RAExpressionAttributeOccurrences occurrences;

    public RAExpressionAttributes(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes, RAExpressionAttributeOccurrences occurrences) {
        this.attributes = attributes;
        this.occurrences = occurrences;
    }

    public ImmutableMap<QualifiedAttributeID, ImmutableTerm> asMap() {
        return this.attributes;
    }

    public ImmutableTerm get(QuotedID attributeId) {
        return this.get(new QualifiedAttributeID(null, attributeId));
    }

    public ImmutableTerm get(QualifiedAttributeID id) {
        return (ImmutableTerm)this.attributes.get((Object)id);
    }

    RAExpressionAttributeOccurrences getOccurrences() {
        return this.occurrences;
    }

    public ImmutableMap<QuotedID, ImmutableTerm> getUnqualifiedAttributes() {
        return (ImmutableMap)this.selectAttributes(id -> id.getRelation() == null).collect(ImmutableCollectors.toMap(e -> ((QualifiedAttributeID)e.getKey()).getAttribute(), Map.Entry::getValue));
    }

    Stream<Map.Entry<QualifiedAttributeID, ImmutableTerm>> selectAttributes(Predicate<QualifiedAttributeID> condition) {
        return this.attributes.entrySet().stream().filter(e -> condition.test((QualifiedAttributeID)e.getKey()));
    }

    public String toString() {
        return "attributes: " + this.attributes + " with " + this.occurrences;
    }
}

