/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.sqlparser.ExpressionParser;
import it.unibz.inf.ontop.spec.sqlparser.JSqlParserTools;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.spec.sqlparser.RAOperations;
import it.unibz.inf.ontop.spec.sqlparser.exception.IllegalJoinException;
import it.unibz.inf.ontop.spec.sqlparser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.sqlparser.exception.UnsupportedSelectQueryRuntimeException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;

public abstract class BasicSelectQueryParser<T, O extends RAOperations<T>> {
    protected final ExpressionParser expressionParser;
    protected final TermFactory termFactory;
    protected final QuotedIDFactory idfac;
    private final MetadataLookup metadata;
    protected final O operations;
    private int relationIndex = 0;

    protected abstract T create(NamedRelationDefinition var1);

    protected BasicSelectQueryParser(MetadataLookup metadata, CoreSingletons coreSingletons, O operations) {
        this.expressionParser = new ExpressionParser(metadata.getQuotedIDFactory(), coreSingletons);
        this.idfac = metadata.getQuotedIDFactory();
        this.metadata = metadata;
        this.termFactory = coreSingletons.getTermFactory();
        this.operations = operations;
    }

    protected abstract T translateSelect(SelectBody var1, List<WithItem> var2);

    protected PlainSelect getPlainSelect(SelectBody selectBody) {
        if (!(selectBody instanceof PlainSelect)) {
            throw new UnsupportedSelectQueryRuntimeException("Complex SELECT statements are not supported", selectBody);
        }
        PlainSelect plainSelect = (PlainSelect)selectBody;
        if (plainSelect.getIntoTables() != null) {
            throw new InvalidSelectQueryRuntimeException("SELECT INTO is not allowed in mappings", selectBody);
        }
        return plainSelect;
    }

    protected T translateJoins(FromItem left, List<Join> joins) throws IllegalJoinException {
        if (left == null) {
            return this.operations.create();
        }
        T current = this.translateFromItem(left);
        if (joins != null) {
            for (Join join : joins) {
                current = this.join(current, join);
            }
        }
        return current;
    }

    private T translateFromItem(FromItem fromItem) {
        return new FromItemProcessor().translate(fromItem);
    }

    protected T join(T left, Join join) throws IllegalJoinException {
        T right = this.translateFromItem(join.getRightItem());
        if (join.isApply()) {
            if (join.isLeft() || join.isRight() || join.isFull() || join.isSemi() || join.isInner() || join.isNatural() || !join.getOnExpressions().isEmpty() || !join.getUsingColumns().isEmpty()) {
                throw new InvalidSelectQueryRuntimeException("Invalid APPLY join", join);
            }
            if (!join.isCross() && !join.isOuter()) {
                throw new InvalidSelectQueryRuntimeException("APPLY must be either CROSS or OUTER", join);
            }
            return this.operations.crossJoin(left, right);
        }
        if (join.isStraight() && (join.isLeft() || join.isRight() || join.isFull() || join.isSemi() || join.isOuter() || join.isInner() || join.isNatural() || join.isCross())) {
            throw new InvalidSelectQueryRuntimeException("Invalid STRAIGHT_JOIN", join);
        }
        if (join.isSimple()) {
            if (join.isLeft() || join.isRight() || join.isFull() || join.isSemi() || join.isInner() || join.isNatural() || join.isCross() || !join.getOnExpressions().isEmpty() || !join.getUsingColumns().isEmpty()) {
                throw new InvalidSelectQueryRuntimeException("Invalid simple join", join);
            }
            if (join.isOuter()) {
                throw new UnsupportedSelectQueryRuntimeException("Simple OUTER join is not supported", join);
            }
            return this.operations.crossJoin(left, right);
        }
        if (join.isCross()) {
            if (!join.getOnExpressions().isEmpty() || !join.getUsingColumns().isEmpty()) {
                throw new InvalidSelectQueryRuntimeException("CROSS JOIN cannot have USING/ON conditions", join);
            }
            return this.operations.crossJoin(left, right);
        }
        if (join.isNatural()) {
            if (!join.getOnExpressions().isEmpty() || !join.getUsingColumns().isEmpty()) {
                throw new InvalidSelectQueryRuntimeException("NATURAL JOIN cannot have USING/ON conditions", join);
            }
            return this.operations.naturalJoin(left, right);
        }
        if (!join.getOnExpressions().isEmpty()) {
            if (!join.getUsingColumns().isEmpty()) {
                throw new InvalidSelectQueryRuntimeException("JOIN cannot have both USING and ON", join);
            }
            if (join.isSemi()) {
                return left;
            }
            Function<RAExpressionAttributes, ImmutableList<ImmutableExpression>> getAtomOnExpression = attributes -> (ImmutableList)join.getOnExpressions().stream().flatMap(exp -> this.expressionParser.parseBooleanExpression((Expression)exp, (RAExpressionAttributes)attributes).stream()).collect(ImmutableCollectors.toList());
            if (join.isLeft()) {
                return this.leftJoinOn(left, right, getAtomOnExpression, join);
            }
            if (join.isRight()) {
                return this.leftJoinOn(right, left, getAtomOnExpression, join);
            }
            if (join.isFull()) {
                return this.fullJoinOn(right, left, getAtomOnExpression, join);
            }
            return this.operations.joinOn(left, right, getAtomOnExpression);
        }
        if (!join.getUsingColumns().isEmpty()) {
            if (join.isSemi()) {
                throw new InvalidSelectQueryRuntimeException("Invalid SEMI JOIN", join);
            }
            if (join.getUsingColumns().stream().anyMatch(p -> p.getTable() != null)) {
                throw new InvalidSelectQueryRuntimeException("JOIN USING columns cannot be qualified", join);
            }
            ImmutableSet using = (ImmutableSet)join.getUsingColumns().stream().map(p -> this.idfac.createAttributeID(p.getColumnName())).collect(ImmutableCollectors.toSet());
            if (join.isLeft()) {
                return this.leftJoinUsing(left, right, (ImmutableSet<QuotedID>)using, join);
            }
            if (join.isRight()) {
                return this.leftJoinUsing(right, left, (ImmutableSet<QuotedID>)using, join);
            }
            if (join.isFull()) {
                return this.fullJoinUsing(right, left, (ImmutableSet<QuotedID>)using, join);
            }
            return this.operations.joinUsing(left, right, (ImmutableSet<QuotedID>)using);
        }
        throw new InvalidSelectQueryRuntimeException("[INNER|OUTER] JOIN requires either ON or USING", join);
    }

    protected T leftJoinUsing(T left, T right, ImmutableSet<QuotedID> using, Join join) {
        throw new UnsupportedSelectQueryRuntimeException("[LEFT|RIGHT] OUTER join is not supported", join);
    }

    protected T fullJoinUsing(T left, T right, ImmutableSet<QuotedID> using, Join join) {
        throw new UnsupportedSelectQueryRuntimeException("FULL OUTER join is not supported", join);
    }

    protected T leftJoinOn(T left, T right, Function<RAExpressionAttributes, ImmutableList<ImmutableExpression>> getAtomOnExpression, Join join) {
        throw new UnsupportedSelectQueryRuntimeException("[LEFT|RIGHT] OUTER join is not supported", join);
    }

    protected T fullJoinOn(T left, T right, Function<RAExpressionAttributes, ImmutableList<ImmutableExpression>> getAtomOnExpression, Join join) {
        throw new UnsupportedSelectQueryRuntimeException("FULL OUTER join is not supported", join);
    }

    public ImmutableList<Variable> createAttributeVariables(RelationDefinition relation) {
        ++this.relationIndex;
        return (ImmutableList)relation.getAttributes().stream().map(attribute -> this.termFactory.getVariable(attribute.getID().getName() + this.relationIndex)).collect(ImmutableCollectors.toList());
    }

    protected void validateFromItem(Table table) {
    }

    private class FromItemProcessor
    implements FromItemVisitor {
        private T result;

        private FromItemProcessor() {
        }

        T translate(FromItem fromItem) {
            fromItem.accept((FromItemVisitor)this);
            return this.result;
        }

        public void visit(Table table) {
            if (table.getPivot() != null || table.getUnPivot() != null) {
                throw new UnsupportedSelectQueryRuntimeException("PIVOT/UNPIVOT are not supported", table);
            }
            BasicSelectQueryParser.this.validateFromItem(table);
            RelationID id = JSqlParserTools.getRelationId(BasicSelectQueryParser.this.idfac, table);
            try {
                NamedRelationDefinition relation = BasicSelectQueryParser.this.metadata.getRelation(id);
                Object rae = BasicSelectQueryParser.this.create(relation);
                this.result = table.getAlias() == null ? rae : this.alias(rae, table.getAlias());
            }
            catch (MetadataExtractionException e) {
                throw new InvalidSelectQueryRuntimeException(e.getMessage(), id);
            }
        }

        public void visit(SubSelect subSelect) {
            if (subSelect.getAlias() == null || subSelect.getAlias().getName() == null) {
                throw new InvalidSelectQueryRuntimeException("SUB-SELECT must have an alias", subSelect);
            }
            if (subSelect.getPivot() != null || subSelect.getUnPivot() != null) {
                throw new UnsupportedSelectQueryRuntimeException("PIVOT/UNPIVOT are not supported", subSelect);
            }
            Object rae = BasicSelectQueryParser.this.translateSelect(subSelect.getSelectBody(), subSelect.getWithItemsList());
            this.result = this.alias(rae, subSelect.getAlias());
        }

        public void visit(SubJoin subjoin) {
            if (subjoin.getAlias() == null || subjoin.getAlias().getName() == null) {
                throw new InvalidSelectQueryRuntimeException("SUB-JOIN must have an alias", subjoin);
            }
            if (subjoin.getPivot() != null || subjoin.getUnPivot() != null) {
                throw new UnsupportedSelectQueryRuntimeException("PIVOT/UNPIVOT are not supported", subjoin);
            }
            try {
                Object rae = BasicSelectQueryParser.this.translateJoins(subjoin.getLeft(), subjoin.getJoinList());
                this.result = this.alias(rae, subjoin.getAlias());
            }
            catch (IllegalJoinException e) {
                throw new InvalidSelectQueryRuntimeException(e.toString(), subjoin);
            }
        }

        public void visit(LateralSubSelect lateralSubSelect) {
            throw new UnsupportedSelectQueryRuntimeException("LateralSubSelects are not supported", lateralSubSelect);
        }

        public void visit(ValuesList valuesList) {
            throw new UnsupportedSelectQueryRuntimeException("ValuesLists are not supported", valuesList);
        }

        public void visit(TableFunction tableFunction) {
            throw new UnsupportedSelectQueryRuntimeException("TableFunction are not supported", tableFunction);
        }

        public void visit(ParenthesisFromItem parenthesisFromItem) {
            throw new UnsupportedSelectQueryRuntimeException("ParenthesisFromItem are not supported", parenthesisFromItem);
        }

        private T alias(T rae, Alias alias) {
            if (alias.getAliasColumns() != null) {
                throw new UnsupportedSelectQueryRuntimeException("Alias columns are not supported", alias);
            }
            RelationID aliasId = BasicSelectQueryParser.this.idfac.createRelationID(alias.getName());
            return BasicSelectQueryParser.this.operations.withAlias(rae, aliasId);
        }
    }
}

