/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.BooleanDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import java.util.Map;

public class SQLServerDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String BIT_STR = "BIT";
    public static final String DATETIME_STR = "DATETIME";
    public static final String DATETIME2_STR = "DATETIME2";
    public static final String DATETIMEOFFSET_STR = "DATETIMEOFFSET";
    public static final String UNIQUEIDENTIFIER_STR = "UNIQUEIDENTIFIER";
    public static final String DEFAULT_DECIMAL_STR = "DECIMAL(38, 19)";
    public static final String INT_IDENTITY_STR = "INT IDENTITY";
    public static final String PHONE_STR = "PHONE";
    public static final String NAME_STR = "NAME";

    @AssistedInject
    private SQLServerDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(SQLServerDBTypeFactory.createSQLServerTypeMap(rootTermType, typeFactory), SQLServerDBTypeFactory.createSQLServerCodeMap());
    }

    private static Map<String, DBTermType> createSQLServerTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        StringDBTermType nvarcharType = new StringDBTermType("NVARCHAR", "NVARCHAR(max)", rootAncestry, typeFactory.getXsdStringDatatype());
        StringDBTermType phoneType = new StringDBTermType(PHONE_STR, rootAncestry, typeFactory.getXsdStringDatatype());
        StringDBTermType nameType = new StringDBTermType(NAME_STR, rootAncestry, typeFactory.getXsdStringDatatype());
        BooleanDBTermType bitType = new BooleanDBTermType(BIT_STR, rootAncestry, typeFactory.getXsdBooleanDatatype());
        DatetimeDBTermType datetimeType = new DatetimeDBTermType(DATETIME_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        DatetimeDBTermType datetime2Type = new DatetimeDBTermType(DATETIME2_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        DatetimeDBTermType dateTimeOffset = new DatetimeDBTermType(DATETIMEOFFSET_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        NonStringNonNumberNonBooleanNonDatetimeDBTermType uniqueIdType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(UNIQUEIDENTIFIER_STR, rootTermType.getAncestry(), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.WITH_ALL);
        NumberDBTermType defaultDecimalType = new NumberDBTermType(DEFAULT_DECIMAL_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        Map<String, DBTermType> map = SQLServerDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put("NVARCHAR", (DBTermType)nvarcharType);
        map.put(BIT_STR, (DBTermType)bitType);
        map.put(DATETIME_STR, (DBTermType)datetimeType);
        map.put(DATETIME2_STR, (DBTermType)datetime2Type);
        map.put(DATETIMEOFFSET_STR, (DBTermType)dateTimeOffset);
        map.put(UNIQUEIDENTIFIER_STR, (DBTermType)uniqueIdType);
        map.put(DEFAULT_DECIMAL_STR, (DBTermType)defaultDecimalType);
        map.put(INT_IDENTITY_STR, map.get("INT"));
        map.put(PHONE_STR, (DBTermType)phoneType);
        map.put(NAME_STR, (DBTermType)nameType);
        return map;
    }

    private static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createSQLServerCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = SQLServerDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.BOOLEAN, BIT_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, "NVARCHAR");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, DATETIME2_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, "FLOAT");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, DEFAULT_DECIMAL_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "1";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "0";
    }
}

