/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.DatabaseInfoSupplier;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import java.util.Map;
import java.util.Optional;

public class H2SQLDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String GEOMETRY_STR = "GEOMETRY";
    public static final String DEFAULT_DECIMAL_STR = "DECIMAL(20, 6)";
    private final DatabaseInfoSupplier databaseInfoSupplier;

    @AssistedInject
    private H2SQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory, DatabaseInfoSupplier databaseInfoSupplier) {
        super(H2SQLDBTypeFactory.createH2SQLTypeMap(rootTermType, typeFactory), H2SQLDBTypeFactory.createH2SQLCodeMap());
        this.databaseInfoSupplier = databaseInfoSupplier;
    }

    private static Map<String, DBTermType> createH2SQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        Map<String, DBTermType> map = H2SQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        NonStringNonNumberNonBooleanNonDatetimeDBTermType rootDBType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType("AbstractDBType", rootTermType.getAncestry(), true);
        TermTypeAncestry rootAncestry = rootDBType.getAncestry();
        ConcreteNumericRDFDatatype xsdDecimal = typeFactory.getXsdDecimalDatatype();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        map.put("DECIMAL", (DBTermType)new NumberDBTermType("DECIMAL", DEFAULT_DECIMAL_STR, rootAncestry, (RDFDatatype)xsdDecimal, DBTermType.Category.DECIMAL));
        StringDBTermType textType = new StringDBTermType("TEXT", "CHARACTER VARYING(1000000)", rootAncestry, typeFactory.getXsdStringDatatype());
        map.put("TEXT", (DBTermType)textType);
        map.put(GEOMETRY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOMETRY_STR, rootAncestry, xsdString));
        return map;
    }

    private static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createH2SQLCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = H2SQLDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOMETRY, GEOMETRY_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public Optional<String> getDBNaNLexicalValue() {
        return Optional.empty();
    }

    @Override
    public boolean supportsDBGeometryType() {
        return true;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return true;
    }
}

