/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.ArrayDBTermType;
import it.unibz.inf.ontop.model.type.impl.DateDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.JsonDBTermTypeImpl;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class BigQueryDBTypeFactory
extends DefaultSQLDBTypeFactory {
    private static final String INT64_STR = "INT64";
    private static final String FLOAT64_STR = "FLOAT64";
    private static final String STRING_STR = "STRING";
    protected static final String GEOGRAPHY_STR = "GEOGRAPHY";
    protected static final String JSON_STR = "JSON";
    protected static final String RECORD_STR = "RECORD";
    protected static final String STRUCT_STR = "STRUCT";
    protected static final String BYTES_STR = "BYTES";
    protected static final String ARRAY_STR = "ARRAY<T>";

    protected BigQueryDBTypeFactory(Map<String, DBTermType> typeMap, ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> defaultTypeCodeMap) {
        super(typeMap, defaultTypeCodeMap);
    }

    @AssistedInject
    protected BigQueryDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(BigQueryDBTypeFactory.createBigQueryTypeMap(rootTermType, typeFactory), BigQueryDBTypeFactory.createBigQueryCodeMap(), BigQueryDBTypeFactory.createGenericAbstractTypeMap(rootTermType, typeFactory));
    }

    private static ImmutableList<GenericDBTermType> createGenericAbstractTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ArrayDBTermType abstractArrayType = new ArrayDBTermType(ARRAY_STR, rootAncestry, s -> {
            if (s.equals("ARRAY")) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBStringType());
            }
            if (!s.startsWith("ARRAY<") || !s.endsWith(">")) {
                return Optional.empty();
            }
            String contents = s.substring(6, s.length() - 1);
            int depth = 0;
            for (int i = 0; i < contents.length(); ++i) {
                if (contents.charAt(i) == '<') {
                    ++depth;
                    continue;
                }
                if (contents.charAt(i) == '>') {
                    --depth;
                    continue;
                }
                if (contents.charAt(i) != ',' || depth != 0) continue;
                return Optional.empty();
            }
            if (depth != 0) {
                return Optional.empty();
            }
            return Optional.of(typeFactory.getDBTypeFactory().getDBTermType(contents));
        }){

            public boolean isPreventDistinctRecommended() {
                return true;
            }
        };
        ArrayList<1> list = new ArrayList<1>();
        list.add(abstractArrayType);
        return ImmutableList.copyOf(list);
    }

    protected static Map<String, DBTermType> createBigQueryTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ConcreteNumericRDFDatatype xsdInteger = typeFactory.getXsdIntegerDatatype();
        ConcreteNumericRDFDatatype xsdDouble = typeFactory.getXsdDoubleDatatype();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        RDFDatatype xsdBoolean = typeFactory.getXsdBooleanDatatype();
        RDFDatatype hexBinary = typeFactory.getDatatype(XSD.HEXBINARY);
        Map<String, DBTermType> map = BigQueryDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        DateDBTermType dateType = new DateDBTermType("DATE", rootAncestry, typeFactory.getDatatype(XSD.DATE));
        NumberDBTermType int64Type = new NumberDBTermType(INT64_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        NumberDBTermType float64Type = new NumberDBTermType(FLOAT64_STR, rootAncestry, (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE);
        StringDBTermType stringType = new StringDBTermType(STRING_STR, rootAncestry, xsdString);
        NonStringNonNumberNonBooleanNonDatetimeDBTermType bytesType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BYTES_STR, rootAncestry, hexBinary);
        map.put("DATE", (DBTermType)dateType);
        map.put(INT64_STR, (DBTermType)int64Type);
        map.put(FLOAT64_STR, (DBTermType)float64Type);
        map.put(STRING_STR, (DBTermType)stringType);
        map.put(BYTES_STR, (DBTermType)bytesType);
        map.put(GEOGRAPHY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOGRAPHY_STR, rootAncestry, xsdString));
        map.put(JSON_STR, (DBTermType)new JsonDBTermTypeImpl(JSON_STR, rootAncestry){

            public boolean isPreventDistinctRecommended() {
                return true;
            }
        });
        map.put(RECORD_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(RECORD_STR, rootAncestry, xsdString){

            public boolean isPreventDistinctRecommended() {
                return true;
            }
        });
        map.put(STRUCT_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(STRUCT_STR, rootAncestry, xsdString){

            public boolean isPreventDistinctRecommended() {
                return true;
            }
        });
        map.remove("DOUBLE PRECISION");
        map.remove("VARCHAR");
        map.remove("NVARCHAR");
        map.remove("BINARY LARGE OBJECT");
        map.remove("BINARY");
        map.remove("BINARY VARYING");
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createBigQueryCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = BigQueryDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, FLOAT64_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, STRING_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOGRAPHY, GEOGRAPHY_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.JSON, JSON_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, BYTES_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.ARRAY, ARRAY_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public boolean supportsDBGeometryType() {
        return false;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return true;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return false;
    }

    @Override
    public boolean supportsJson() {
        return true;
    }

    @Override
    public boolean supportsArrayType() {
        return true;
    }
}

