/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DatabaseInfoSupplier;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DecomposeStrictEqualitySQLTimestampISONormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultImplicitDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNumberNormAsBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.MySQLEncodeURLorIRIFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NonPostProcessedSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBGroupConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MySQLDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    protected static final String UUID_STR = "UUID";
    protected static final String CURRENT_TZ_STR = "REPLACE(TIME_FORMAT(TIMEDIFF(NOW(),CONVERT_TZ(NOW(),@@session.time_zone,'+00:00')),'+%H:%i'),'+-','-')";
    private static final String REGEXP_LIKE_STR = "REGEXP_LIKE";
    private static final String UNSUPPORTED_MSG = "Not supported by MySQL";
    private final DatabaseInfoSupplier databaseInfoSupplier;

    @Inject
    protected MySQLDBFunctionSymbolFactory(TypeFactory typeFactory, DatabaseInfoSupplier databaseInfoSupplier) {
        super(MySQLDBFunctionSymbolFactory.createMySQLRegularFunctionTable(typeFactory), typeFactory);
        this.databaseInfoSupplier = databaseInfoSupplier;
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createMySQLRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType dbBooleanType = dbTypeFactory.getDBBooleanType();
        DBTermType dbIntType = dbTypeFactory.getDBLargeIntegerType();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(MySQLDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createNormalizationMap() {
        HashMap<DBTermType, Object> map = new HashMap<DBTermType, Object>();
        map.putAll((Map<DBTermType, Object>)super.createNormalizationMap());
        DBTermType timestamp = this.dbTypeFactory.getDBTermType("TIMESTAMP");
        DBTypeConversionFunctionSymbol timestampNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(timestamp);
        map.put(timestamp, timestampNormFunctionSymbol);
        DBTermType bitOne = this.dbTypeFactory.getDBTermType("BIT", 1);
        map.put(bitOne, new DefaultNumberNormAsBooleanFunctionSymbol(bitOne, this.dbStringType));
        DBTermType year = this.dbTypeFactory.getDBTermType("YEAR");
        map.put(year, new NonPostProcessedSimpleDBCastFunctionSymbol(year, this.dbStringType, Serializers.getCastSerializer((DBTermType)this.dbStringType)));
        DBTermType varBinary = this.dbTypeFactory.getDBTermType("VARBINARY");
        map.put(varBinary, this.createHexBinaryNormFunctionSymbol(varBinary));
        return ImmutableMap.copyOf(map);
    }

    protected DBFunctionSymbol createDBGroupConcat(DBTermType dbStringType, boolean isDistinct) {
        return new NullIgnoringDBGroupConcatFunctionSymbol(dbStringType, isDistinct, (terms, termConverter, termFactory) -> String.format("GROUP_CONCAT(%s%s SEPARATOR %s)", isDistinct ? "DISTINCT " : "", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1))));
    }

    @Override
    protected String serializeHexBinaryNorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("UPPER(HEX(%s))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDateTimeDenormFunctionSymbol(DBTermType timestampType) {
        return super.createDateTimeDenormFunctionSymbol(timestampType);
    }

    protected DBTermType inferOutputTypeMathOperator(String dbMathOperatorName, DBTermType arg1Type, DBTermType arg2Type) {
        if (dbMathOperatorName.equals("/")) {
            return this.dbDecimalType;
        }
        return super.inferOutputTypeMathOperator(dbMathOperatorName, arg1Type, arg2Type);
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("INSTR(%s,%s) > 0", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,INSTR(%s,%s)-1)", str, str, before);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTRING(%s,LOCATE(%s,%s) + LENGTH(%s), SIGN(LOCATE(%s,%s)) * LENGTH(%s))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("MD5(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA1(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s,256)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA384(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s,384)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s,512)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new RuntimeException("TODO: support it");
    }

    @Override
    protected String serializeDBRowNumber(Function<ImmutableTerm, String> converter, TermFactory termFactory) {
        return super.serializeDBRowNumber(converter, termFactory);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDateTimeNormFunctionSymbol(DBTermType dbDateTimestampType) {
        return new DecomposeStrictEqualitySQLTimestampISONormFunctionSymbol(dbDateTimestampType, this.dbStringType, (terms, converter, factory) -> this.serializeDateTimeNorm(dbDateTimestampType, (ImmutableList<? extends ImmutableTerm>)terms, converter));
    }

    protected String serializeDateTimeNorm(DBTermType dbDateTimestampType, ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter) {
        String dateTimeStringWithoutTz = String.format("REPLACE(CAST(%s AS CHAR(30) CHARACTER SET utf8),' ', 'T')", termConverter.apply((ImmutableTerm)terms.get(0)));
        return dbDateTimestampType.getName().equals("TIMESTAMP") ? String.format("CONCAT(%s,%s)", dateTimeStringWithoutTz, CURRENT_TZ_STR) : dateTimeStringWithoutTz;
    }

    @Override
    protected String serializeDateTimeNormWithTZ(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("This method should not be called for MySQL");
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return (DBConcatFunctionSymbol)this.getRegularDBFunctionSymbol("CONCAT", arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDatetimeToDatetimeCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        return new DefaultImplicitDBCastFunctionSymbol(inputType, targetType);
    }

    @Override
    protected DBFunctionSymbol createEncodeURLorIRI(boolean preserveInternationalChars) {
        return new MySQLEncodeURLorIRIFunctionSymbolImpl(this.dbStringType, preserveInternationalChars);
    }

    @Override
    protected String getUUIDNameInDialect() {
        return UUID_STR;
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_MATCHES_2", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbBooleanType, false, (terms, termConverter, termFactory) -> String.format("(CAST(%s AS BINARY) REGEXP BINARY %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1))));
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches3() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_MATCHES_3", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbBooleanType, false, this::serializeDBRegexpMatches3);
    }

    protected String serializeDBRegexpMatches3(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String string = termConverter.apply((ImmutableTerm)terms.get(0));
        String pattern = termConverter.apply((ImmutableTerm)terms.get(1));
        ImmutableTerm flagTerm = (ImmutableTerm)terms.get(2);
        if (flagTerm instanceof DBConstant) {
            String flags;
            switch (flags = ((DBConstant)flagTerm).getValue()) {
                case "": {
                    return String.format("(CAST(%s AS BINARY) REGEXP BINARY %s)", string, pattern);
                }
                case "i": {
                    return String.format("(%s REGEXP %s)", string, pattern);
                }
            }
        }
        return this.getRegularDBFunctionSymbol(REGEXP_LIKE_STR, 3).getNativeDBString(terms, termConverter, termFactory);
    }

    @Override
    protected String serializeMillisBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("ROUND(TIMESTAMPDIFF(MICROSECOND, %s, %s)/1000)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    private boolean isMySQLVersion5OrBelow() {
        return this.databaseInfoSupplier.getDatabaseVersion().isPresent() && !((String)this.databaseInfoSupplier.getDatabaseVersion().get()).toLowerCase().contains("maria") && this.databaseInfoSupplier.getDatabaseVersion().map(s -> Integer.parseInt(s.substring(0, s.indexOf(".")))).filter(s -> s < 8).isPresent();
    }

    @Override
    protected String serializeCheckAndConvertDouble(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        if (this.isMySQLVersion5OrBelow()) {
            return String.format("CASE WHEN %1$s NOT REGEXP '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$' THEN NULL ELSE %1$s + 0.0 END", term);
        }
        return String.format("CASE WHEN %1$s NOT REGEXP '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$' THEN NULL ELSE CAST(%1$s AS DOUBLE) END", term);
    }

    @Override
    protected String serializeCheckAndConvertFloat(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        if (this.isMySQLVersion5OrBelow()) {
            return String.format("CASE WHEN %1$s NOT REGEXP '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$' THEN NULL ELSE %1$s + 0.0 END", term);
        }
        return String.format("CASE WHEN %1$s NOT REGEXP '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$' THEN NULL ELSE CAST(%1$s AS FLOAT) END", term);
    }

    @Override
    protected String serializeCheckAndConvertFloatFromNonFPNumeric(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        if (this.isMySQLVersion5OrBelow()) {
            return String.format("CASE WHEN (CAST(%1$s AS DECIMAL(60,30)) NOT BETWEEN -3.40E38 AND -1.18E-38 AND CAST(%1$s AS DECIMAL(60,30)) NOT BETWEEN 1.18E-38 AND 3.40E38 AND CAST(%1$s AS DECIMAL(60,30)) != 0) THEN NULL ELSE %1$s + 0.0 END", term);
        }
        return String.format("CASE WHEN (CAST(%1$s AS DECIMAL(60,30)) NOT BETWEEN -3.40E38 AND -1.18E-38 AND CAST(%1$s AS DECIMAL(60,30)) NOT BETWEEN 1.18E-38 AND 3.40E38 AND CAST(%1$s AS DECIMAL(60,30)) != 0) THEN NULL ELSE CAST(%1$s AS FLOAT) END", term);
    }

    @Override
    protected String serializeCheckAndConvertDecimal(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s NOT REGEXP '^[-+]?[0-9]*\\.?[0-9]*$' THEN NULL ELSE CAST(%1$s AS DECIMAL(60,30)) END", term);
    }

    @Override
    protected String serializeCheckAndConvertInteger(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("IF(%1$s REGEXP '[^0-9]+$', NULL , FLOOR(ABS(CAST(%1$s AS DECIMAL(60,30))))  * SIGN(CAST(%1$s AS DECIMAL(60,30)))) ", term);
    }

    @Override
    protected String serializeCheckAndConvertIntegerFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1 WHEN %1$s='0' THEN 0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(CASE WHEN CAST(%1$s AS DECIMAL(60,30)) = 0 THEN 'false' WHEN %1$s = '' THEN 'false' WHEN %1$s = 'NaN' THEN 'false' ELSE 'true' END)", term);
    }

    @Override
    protected String serializeCheckAndConvertStringFromDecimal(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("TRIM(CASE WHEN MOD(%1$s,1) = 0 THEN CAST((%1$s) AS DECIMAL) ELSE %1$s END)+0", term);
    }

    @Override
    protected String serializeCheckAndConvertDateTimeFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CAST(%s AS DATETIME)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDateFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN (%1$s NOT REGEXP '^[0-9]{1,2}/[0-9]{1,2}/[0-9]{4}$' AND %1$s NOT REGEXP '^[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}$' AND %1$s NOT REGEXP '^[0-9]{1,2}-[0-9]{1,2}-[0-9]{4}$' AND %1$s NOT REGEXP '^[0-9]{4}-[0-9]{1,2}-[0-9]{1,2}$' )  THEN NULL ELSE CAST(%1$s AS DATE) END", term);
    }

    public DBBooleanFunctionSymbol getDBIsArray(DBTermType dbType) {
        return new DBBooleanFunctionSymbolWithSerializerImpl("JSON_IS_ARRAY", ImmutableList.of((Object)this.typeFactory.getDBTypeFactory().getDBJsonType()), this.dbBooleanType, false, (terms, termConverter, termFactory) -> String.format("json_type(%s) = 'ARRAY'", termConverter.apply((ImmutableTerm)terms.get(0))));
    }

    @Override
    protected String serializeWeek(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("WEEKOFYEAR(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeDecade(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FLOOR(EXTRACT(YEAR FROM %s) / 10.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCentury(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL(EXTRACT(YEAR FROM %s) / 100.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMillennium(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL(EXTRACT(YEAR FROM %s) / 1000.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMilliseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(EXTRACT(SECOND FROM %s) * 1000 + EXTRACT(MICROSECOND FROM %s) / 1000)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMicroseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(EXTRACT(SECOND FROM %s) * 1000000 + EXTRACT(MICROSECOND FROM %s))", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeDateTrunc(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String template = String.format(" WHEN %s LIKE '%%s' THEN DATE_FORMAT(%s, %%s)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
        ImmutableMap.Builder possiblePartsBuilder = new ImmutableMap.Builder();
        possiblePartsBuilder.put((Object)"century", (Object)"'CC'");
        possiblePartsBuilder.put((Object)"year", (Object)"'%Y-01-01 00:00:00'");
        possiblePartsBuilder.put((Object)"quarter", (Object)"'Q'");
        possiblePartsBuilder.put((Object)"month", (Object)"'%Y-%m-01 00:00:00'");
        possiblePartsBuilder.put((Object)"day", (Object)"'%Y-%m-%d 00:00:00'");
        possiblePartsBuilder.put((Object)"week", (Object)"'IW'");
        possiblePartsBuilder.put((Object)"hour", (Object)"'%Y-%m-%d %H:00:00'");
        possiblePartsBuilder.put((Object)"minute", (Object)"'%Y-%m-%d %H:%i:00'");
        possiblePartsBuilder.put((Object)"second", (Object)"'%Y-%m-%d %H:%i:%s'");
        ImmutableMap possibleParts = possiblePartsBuilder.build();
        StringBuilder serializationBuilder = new StringBuilder("CASE");
        possibleParts.entrySet().stream().forEach(entry -> serializationBuilder.append(String.format(template, entry.getKey(), entry.getValue())));
        serializationBuilder.append(" ELSE NULL END");
        return serializationBuilder.toString();
    }

    public DBFunctionSymbol getDBDateTrunc(String datePart) {
        if (ImmutableSet.of((Object)"microseconds", (Object)"milliseconds", (Object)"microsecond", (Object)"millisecond", (Object)"decade", (Object)"millennium", (Object[])new String[0]).contains((Object)datePart.toLowerCase())) {
            throw new IllegalArgumentException(String.format("MySQL does not support DATE_TRUNC on %s.", datePart));
        }
        return super.getDBDateTrunc(datePart);
    }

    public DBFunctionSymbol getNullIgnoringDBStdev(DBTermType dbType, boolean isPop, boolean isDistinct) {
        if (isDistinct) {
            throw new UnsupportedOperationException("This dialect does not allow the use of DISTINCT with the standard deviation function.");
        }
        return super.getNullIgnoringDBStdev(dbType, isPop, false);
    }

    public DBFunctionSymbol getNullIgnoringDBVariance(DBTermType dbType, boolean isPop, boolean isDistinct) {
        if (isDistinct) {
            throw new UnsupportedOperationException("This dialect does not allow the use of DISTINCT with the variance function.");
        }
        return super.getNullIgnoringDBVariance(dbType, isPop, false);
    }
}

