/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultCastIntegerToStringFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNumberNormAsBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.ForcingFloatingDBAvgFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneDigitBooleanNormFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneDigitDBIsTrueFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WithoutParenthesesSimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Map;
import java.util.function.Function;

public class DB2DBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String CURRENT_TIMESTAMP_SPACE_STR = "CURRENT TIMESTAMP";
    private static final String VARCHAR_STR = "VARCHAR";
    private final DBFunctionSymbolSerializer numberToStringSerializer = (terms, termConverter, termFactory) -> String.format("REPLACE(VARCHAR(%s),' ', '')", termConverter.apply((ImmutableTerm)terms.get(0)));
    private static final String NOT_YET_SUPPORTED_MSG = "Not yet supported for DB2";

    @Inject
    protected DB2DBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(DB2DBFunctionSymbolFactory.createDB2RegularFunctionTable(typeFactory), typeFactory);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createDB2RegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(DB2DBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        WithoutParenthesesSimpleTypedDBFunctionSymbolImpl nowFunctionSymbol = new WithoutParenthesesSimpleTypedDBFunctionSymbolImpl(CURRENT_TIMESTAMP_SPACE_STR, dbTypeFactory.getDBDateTimestampType(), abstractRootDBType);
        table.put((Object)CURRENT_TIMESTAMP_SPACE_STR, (Object)0, (Object)nowFunctionSymbol);
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createNormalizationMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll((Map)super.createNormalizationMap());
        return builder.build();
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createNormalizationTable() {
        HashBasedTable table = HashBasedTable.create();
        table.putAll((Table)super.createNormalizationTable());
        DBTermType smallIntType = this.dbTypeFactory.getDBTermType("SMALLINT");
        table.put((Object)smallIntType, (Object)this.typeFactory.getXsdBooleanDatatype(), (Object)new DefaultNumberNormAsBooleanFunctionSymbol(smallIntType, this.dbStringType));
        return ImmutableTable.copyOf((Table)table);
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return this.createDBConcatOperator(arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, true);
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        if (arity != 2) {
            throw new UnsupportedOperationException("CONCAT is strictly binary in DB2. Please use the operator instead.");
        }
        return new NullRejectingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new OneDigitDBIsTrueFunctionSymbolImpl(dbBooleanType);
    }

    @Override
    protected String serializeDateTimeNormWithTZ(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("REPLACE(VARCHAR_FORMAT(%s,'YYYY-MM-DD HH24:MI:SS.FF'),' ','T')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBTypeConversionFunctionSymbol createBooleanNormFunctionSymbol(DBTermType booleanType) {
        return new OneDigitBooleanNormFunctionSymbolImpl(booleanType, this.dbStringType);
    }

    @Override
    public DBFunctionSymbol getDBSubString2() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 2);
    }

    @Override
    public DBFunctionSymbol getDBSubString3() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 3);
    }

    @Override
    public DBFunctionSymbol getDBCharLength() {
        return this.getRegularDBFunctionSymbol("LENGTH", 1);
    }

    @Override
    public DBFunctionSymbol getDBNow() {
        return this.getRegularDBFunctionSymbol(CURRENT_TIMESTAMP_SPACE_STR, 0);
    }

    @Override
    protected String getUUIDNameInDialect() {
        throw new UnsupportedOperationException("UUID: Not yet supported for DB2");
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(LOCATE(%2$s , %1$s) > 0)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,SIGN(LOCATE(%s,%s)) * (LOCATE(%s,%s)-1))", str, before, str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("RTRIM(SUBSTR(%s,LOCATE(%s,%s)+LENGTH(%s), SIGN(LOCATE(%s,%s))*LENGTH(%s)))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("MD5: Not yet supported for DB2");
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA1: Not yet supported for DB2");
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA256: Not yet supported for DB2");
    }

    protected String serializeSHA384(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA384: Not yet supported for DB2");
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA512: Not yet supported for DB2");
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("Serialization of the time zone: Not yet supported for DB2");
    }

    @Override
    protected DBTypeConversionFunctionSymbol createIntegerToStringCastFunctionSymbol(DBTermType inputType) {
        return new DefaultCastIntegerToStringFunctionSymbol(inputType, this.dbStringType, this.numberToStringSerializer);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDecimalToStringCastFunctionSymbol(DBTermType inputType) {
        return this.createNonIntegerNumberToStringCastFunctionSymbol(inputType);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createFloatDoubleToStringCastFunctionSymbol(DBTermType inputType) {
        return this.createNonIntegerNumberToStringCastFunctionSymbol(inputType);
    }

    protected DBTypeConversionFunctionSymbol createNonIntegerNumberToStringCastFunctionSymbol(DBTermType inputType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, this.dbStringType, this.numberToStringSerializer);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDefaultCastToStringFunctionSymbol(DBTermType inputType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, this.dbStringType, Serializers.getRegularSerializer((String)VARCHAR_STR));
    }

    @Override
    protected DBTypeConversionFunctionSymbol createSimpleCastFunctionSymbol(DBTermType targetType) {
        if (targetType.equals(this.dbTypeFactory.getDBStringType())) {
            return new DefaultSimpleDBCastFunctionSymbol(this.dbTypeFactory.getAbstractRootDBType(), this.dbStringType, Serializers.getRegularSerializer((String)VARCHAR_STR));
        }
        return super.createSimpleCastFunctionSymbol(targetType);
    }

    @Override
    protected DBFunctionSymbol createDBAvg(DBTermType inputType, boolean isDistinct) {
        if (inputType.equals(this.dbIntegerType)) {
            return new ForcingFloatingDBAvgFunctionSymbolImpl(inputType, this.dbDecimalType, isDistinct);
        }
        return super.createDBAvg(inputType, isDistinct);
    }

    @Override
    protected String serializeWeeksBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CAST(TRUNC(WEEKS_BETWEEN(%s, %s)) AS INTEGER)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeDaysBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CAST(TRUNC(DAYS_BETWEEN(%s, %s)) AS INTEGER)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeHoursBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CAST(TRUNC(HOURS_BETWEEN(%s, %s)) AS INTEGER)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeMinutesBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CAST(TRUNC(MINUTES_BETWEEN(%s, %s)) AS INTEGER)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeSecondsBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CAST(TRUNC(SECONDS_BETWEEN(%s, %s)) AS INTEGER)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeMillisBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CAST(TRUNC(SECONDS_BETWEEN(%s, %s),3) AS INTEGER)*1000", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeCheckAndConvertFloatFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CASE WHEN %s THEN 1 ELSE 0 END", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDecimal(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN REGEXP_LIKE(%1$s, '^-?([0-9]+[.]?[0-9]*|[.][0-9]+)$') THEN CAST(%1$s AS DECIMAL(20, 6)) ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertInteger(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN REGEXP_LIKE(%1$s, '^-?([0-9]+[.]?[0-9]*|[.][0-9]+)$') THEN CAST(FLOOR(ABS(CAST(%1$s AS DECIMAL(20,6)))) * SIGN(CAST(%1$s AS DECIMAL)) AS INTEGER) ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(CASE WHEN CAST(%1$s AS DECIMAL(20, 6)) = 0 THEN 'false' WHEN %1$s = '' THEN 'false' ELSE 'true' END)", term);
    }

    @Override
    protected String serializeCheckAndConvertDateFromDateTime(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATE(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDouble(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN TRANSLATE(%1$s, ' ', '0123456789,. ' ) != ''  THEN NULL ELSE CAST(%1$s AS DOUBLE) END", term);
    }

    @Override
    protected String serializeCheckAndConvertFloat(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN TRANSLATE(%1$s, ' ', '0123456789,. ' ) != ''  THEN NULL WHEN (CAST(%1$s AS FLOAT) NOT BETWEEN -3.40E38 AND -1.18E-38 AND CAST(%1$s AS FLOAT) NOT BETWEEN 1.18E-38 AND 3.40E38 AND CAST(%1$s AS FLOAT) != 0) THEN NULL ELSE CAST(%1$s AS FLOAT) END", term);
    }

    @Override
    protected String serializeCheckAndConvertDateFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN (TRANSLATE(%1$s, ' ', '0123456789- ' ) != '' AND TRANSLATE(%1$s, ' ', '0123456789/ ' ) != '' )  THEN NULL ELSE CAST(%1$s AS DATE) END", term);
    }

    @Override
    protected String serializeDecade(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FLOOR(EXTRACT(YEAR FROM %s) / 10.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCentury(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL(EXTRACT(YEAR FROM %s) / 100.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMillennium(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL(EXTRACT(YEAR FROM %s) / 1000.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMilliseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(EXTRACT(SECOND FROM %s) * 1000)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMicroseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FLOOR(EXTRACT(SECOND FROM %s) * 1000000)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeWeek(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("WEEK_ISO(%s)", term);
    }

    @Override
    protected String serializeQuarter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("QUARTER(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }
}

