/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.LensFKSaturator;
import it.unibz.inf.ontop.dbschema.LensMetadataProvider;
import it.unibz.inf.ontop.dbschema.LensNormalizer;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.SerializedMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.BigQueryQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.DremioQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.DuckDBQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.JDBCMetadataProviderFactory;
import it.unibz.inf.ontop.dbschema.impl.MySQLCaseNotSensitiveTableNamesQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.MySQLCaseSensitiveTableNamesQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.PostgreSQLQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SQLServerQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SparkSQLQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.TeiidQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.TrinoQuotedIDFactory;
import it.unibz.inf.ontop.generation.algebra.IQTree2SelectFromWhereConverter;
import it.unibz.inf.ontop.generation.algebra.SQLAlgebraFactory;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SQLInnerJoinExpression;
import it.unibz.inf.ontop.generation.algebra.SQLLeftJoinExpression;
import it.unibz.inf.ontop.generation.algebra.SQLNaryJoinExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOneTupleDummyQueryExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SQLSerializedQuery;
import it.unibz.inf.ontop.generation.algebra.SQLTable;
import it.unibz.inf.ontop.generation.algebra.SQLUnionExpression;
import it.unibz.inf.ontop.generation.algebra.SQLValuesExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.OntopSQLCoreConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCoreSettings;
import it.unibz.inf.ontop.injection.impl.OntopAbstractModule;
import it.unibz.inf.ontop.iq.transform.IQTree2NativeNodeGenerator;
import java.lang.annotation.Annotation;

public class OntopSQLCoreModule
extends OntopAbstractModule {
    private final OntopSQLCoreSettings settings;

    protected OntopSQLCoreModule(OntopSQLCoreConfiguration configuration) {
        super((OntopModelSettings)configuration.getSettings());
        this.settings = configuration.getSettings();
    }

    protected void configure() {
        this.bind(OntopSQLCoreSettings.class).toInstance((Object)this.settings);
        this.bindFromSettings(SelectFromWhereSerializer.class);
        this.bindFromSettings(IQTree2SelectFromWhereConverter.class);
        this.bindFromSettings(DialectExtraNormalizer.class);
        this.bindFromSettings(IQTree2NativeNodeGenerator.class);
        this.bindFromSettings(LensNormalizer.class);
        this.bindFromSettings(LensFKSaturator.class);
        Module sqlAlgebraFactory = this.buildFactory((Iterable)ImmutableList.of(SelectFromWhereWithModifiers.class, SQLSerializedQuery.class, SQLTable.class, SQLInnerJoinExpression.class, SQLLeftJoinExpression.class, SQLNaryJoinExpression.class, SQLUnionExpression.class, SQLFlattenExpression.class, SQLOneTupleDummyQueryExpression.class, SQLValuesExpression.class, SQLOrderComparator.class), SQLAlgebraFactory.class);
        this.install(sqlAlgebraFactory);
        Module serializedMetadataProviderFactory = this.buildFactory((Iterable)ImmutableList.of(SerializedMetadataProvider.class), SerializedMetadataProvider.Factory.class);
        this.install(serializedMetadataProviderFactory);
        Module ontopViewMetadataProviderFactory = this.buildFactory((Iterable)ImmutableList.of(LensMetadataProvider.class), LensMetadataProvider.Factory.class);
        this.install(ontopViewMetadataProviderFactory);
        Module mdProvider = this.buildFactory((Iterable)ImmutableList.of(DBMetadataProvider.class), JDBCMetadataProviderFactory.class);
        this.install(mdProvider);
        for (Class c : ImmutableList.of(BigQueryQuotedIDFactory.class, DremioQuotedIDFactory.class, DuckDBQuotedIDFactory.class, MySQLCaseNotSensitiveTableNamesQuotedIDFactory.class, MySQLCaseSensitiveTableNamesQuotedIDFactory.class, PostgreSQLQuotedIDFactory.class, SQLServerQuotedIDFactory.class, SparkSQLQuotedIDFactory.class, TeiidQuotedIDFactory.class, TrinoQuotedIDFactory.class)) {
            String idFactoryType = QuotedIDFactory.getIDFactoryType((Class)c);
            this.bindFromSettings(Key.get(QuotedIDFactory.class, (Annotation)Names.named((String)idFactoryType)), c);
        }
    }
}

