/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.generation.algebra.SQLValuesExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.Collectors;

@Singleton
public class TeiidSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    @Inject
    private TeiidSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory));
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeOffset(long offset, boolean noSortCondition) {
                return String.format("OFFSET %d ROWS", offset);
            }

            @Override
            public SelectFromWhereSerializer.QuerySerialization visit(SQLValuesExpression sqlValuesExpression) {
                ImmutableMap childColumnIDs = ImmutableMap.of();
                String tuplesSerialized = sqlValuesExpression.getValues().stream().map(tuple -> tuple.stream().map(constant -> TeiidSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)constant, (ImmutableMap<Variable, QualifiedAttributeID>)childColumnIDs)).collect(Collectors.joining(",", " (", ")"))).collect(Collectors.joining(","));
                RelationID alias = this.generateFreshViewAlias();
                String sql = "(VALUES " + tuplesSerialized + " ) AS " + alias;
                ImmutableList<Variable> orderedVariables = sqlValuesExpression.getOrderedVariables();
                ImmutableMap columnIDs = (ImmutableMap)orderedVariables.stream().collect(ImmutableCollectors.toMap(variable -> variable, variable -> new QualifiedAttributeID(null, this.idFactory.createAttributeID(alias + ".expr" + (orderedVariables.indexOf(variable) + 1)))));
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
            }
        });
    }
}

