/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SQLValuesExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.AbstractMap;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class SnowflakeSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    @Inject
    private SnowflakeSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory));
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                return String.format("LIMIT %d OFFSET %d", limit, offset);
            }

            @Override
            protected String serializeOffset(long offset, boolean noSortCondition) {
                return String.format("LIMIT NULL OFFSET %d", offset);
            }

            @Override
            public SelectFromWhereSerializer.QuerySerialization visit(SQLValuesExpression sqlValuesExpression) {
                ImmutableList<Variable> orderedVariables = sqlValuesExpression.getOrderedVariables();
                ImmutableMap<Variable, QuotedID> variableAliases = this.createVariableAliases((ImmutableSet<Variable>)ImmutableSet.copyOf(orderedVariables));
                ImmutableMap childColumnIDs = ImmutableMap.of();
                String tuplesSerialized = sqlValuesExpression.getValues().stream().map(tuple -> tuple.stream().map(constant -> SnowflakeSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)constant, (ImmutableMap<Variable, QualifiedAttributeID>)childColumnIDs)).collect(Collectors.joining(",", " (", ")"))).collect(Collectors.joining(","));
                RelationID valuesAlias = this.generateFreshViewAlias();
                RelationID wrapperAlias = this.generateFreshViewAlias();
                String internalColumnNames = orderedVariables.stream().map(arg_0 -> variableAliases.get(arg_0)).map(QuotedID::getName).collect(Collectors.joining(",", " (", ")"));
                String valuesSql = "(VALUES " + tuplesSerialized + ") AS " + valuesAlias + internalColumnNames;
                String renamingProjection = orderedVariables.stream().map(arg_0 -> variableAliases.get(arg_0)).map(quotedID -> String.format("%s.%s AS %s", valuesAlias.getSQLRendering(), quotedID.getName(), quotedID.getSQLRendering())).collect(Collectors.joining(","));
                String sql = "(SELECT " + renamingProjection + " FROM " + valuesSql + ") AS " + wrapperAlias;
                ImmutableMap<Variable, QualifiedAttributeID> columnIDs = this.attachRelationAlias(wrapperAlias, variableAliases);
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, columnIDs);
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                Object dummyTemp;
                StringBuilder builder = new StringBuilder();
                Object dummy = "t";
                do {
                    dummyTemp = dummy = "_" + (String)dummy;
                } while (!allColumnIDs.values().stream().noneMatch(arg_0 -> 1.lambda$serializeFlatten$3((String)dummyTemp, arg_0)));
                builder.append(String.format("%s, LATERAL FLATTEN(%s) AS %s(%s, %s, %s, %s, %s, %s)", subQuerySerialization.getString(), ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering(), this.generateFreshViewAlias().getSQLRendering(), dummy, dummy, dummy, indexVar.map(v -> ((QualifiedAttributeID)allColumnIDs.get(v)).getAttribute().getName()).orElse("dummyVariable"), ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getAttribute().getName(), dummy));
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(builder.toString(), (ImmutableMap<Variable, QualifiedAttributeID>)((ImmutableMap)allColumnIDs.entrySet().stream().filter(e -> e.getKey() != flattenedVar).map(e -> e.getKey() != outputVar && e.getKey() != indexVar.orElse(null) ? e : new AbstractMap.SimpleEntry<Variable, QualifiedAttributeID>((Variable)e.getKey(), new QualifiedAttributeID(((QualifiedAttributeID)e.getValue()).getRelation(), this.idFactory.createAttributeID(((QualifiedAttributeID)e.getValue()).getAttribute().getName().toUpperCase())))).collect(ImmutableCollectors.toMap())));
            }

            private static /* synthetic */ boolean lambda$serializeFlatten$3(String dummyTemp, QualifiedAttributeID a) {
                return a.getAttribute().getName().startsWith(dummyTemp);
            }
        });
    }
}

