/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.AttributeAliasFactory;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.LimitLengthAttributeAliasFactory;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

@Singleton
public class OracleSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer {
    public static final int NAME_MAX_LENGTH = 30;
    public static final int NAME_NUMBER_LENGTH = 3;

    @Inject
    private OracleSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory){

            @Override
            protected String serializeDBConstant(DBConstant constant) {
                DBTermType dbType = constant.getType();
                switch (dbType.getCategory()) {
                    case DATETIME: {
                        return String.format("TIMESTAMP '%s'", constant.getValue());
                    }
                }
                return super.serializeDBConstant(constant);
            }
        });
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected AttributeAliasFactory createAttributeAliasFactory() {
                return new LimitLengthAttributeAliasFactory(this.idFactory, 30, 3);
            }

            @Override
            protected String serializeDummyTable() {
                return "FROM dual";
            }

            @Override
            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                return String.format("OFFSET %d ROWS\nFETCH NEXT %d ROWS ONLY", offset, limit);
            }

            @Override
            protected String serializeLimit(long limit, boolean noSortCondition) {
                return String.format("FETCH NEXT %d ROWS ONLY", limit);
            }

            @Override
            protected String serializeOffset(long offset, boolean noSortCondition) {
                return String.format("OFFSET %d ROWS\nFETCH NEXT 99999999 ROWS ONLY", offset);
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                StringBuilder builder = new StringBuilder();
                builder.append(String.format("%s CROSS JOIN JSON_TABLE(%s, '$[*]' COLUMNS(%s VARCHAR2(1000) FORMAT JSON PATH '$'", subQuerySerialization.getString(), ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering(), ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering()));
                indexVar.ifPresent(v -> builder.append(String.format(", %s FOR ORDINALITY", ((QualifiedAttributeID)allColumnIDs.get(v)).getSQLRendering())));
                builder.append(String.format(")) %s", this.generateFreshViewAlias().getSQLRendering()));
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(builder.toString(), (ImmutableMap<Variable, QualifiedAttributeID>)((ImmutableMap)allColumnIDs.entrySet().stream().filter(e -> e.getKey() != flattenedVar).collect(ImmutableCollectors.toMap())));
            }
        });
    }
}

