/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Optional;

@Singleton
public class DuckDBSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    @Inject
    private DuckDBSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory){

            @Override
            protected String serializeDatetimeConstant(String datetime, DBTermType dbType) {
                return String.format("TIMESTAMP %s", this.serializeStringConstant(datetime));
            }
        });
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                return String.format("OFFSET %d LIMIT %d", offset, limit);
            }

            @Override
            protected String serializeOffset(long offset, boolean noSortCondition) {
                return String.format("OFFSET %d", offset);
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                String expression = ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering();
                String flattenCall = indexVar.isPresent() ? String.format("UNNEST(%s) AS %s, UNNEST(RANGE(1, len(%s) + 1)) as %s", expression, ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering(), expression, ((QualifiedAttributeID)allColumnIDs.get((Object)indexVar.get())).getSQLRendering()) : String.format("(UNNEST(%s)) AS %s", expression, ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering());
                return this.serializeFlattenAsFunction(flattenedVar, allColumnIDs, subQuerySerialization, flattenCall);
            }
        });
    }
}

