/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.generation.normalization.impl.AbstractTypingNullsDialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class TypingNullsInUnionDialectExtraNormalizer
extends AbstractTypingNullsDialectExtraNormalizer {
    protected final SingleTermTypeExtractor uniqueTermTypeExtractor;

    @Inject
    protected TypingNullsInUnionDialectExtraNormalizer(CoreSingletons coreSingletons, SingleTermTypeExtractor uniqueTermTypeExtractor) {
        super(coreSingletons);
        this.uniqueTermTypeExtractor = uniqueTermTypeExtractor;
    }

    public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList updatedChildren = (ImmutableList)children.stream().map(arg_0 -> ((TypingNullsInUnionDialectExtraNormalizer)this).transform(arg_0)).collect(ImmutableCollectors.toList());
        ImmutableSet nullVariables = (ImmutableSet)updatedChildren.stream().map(IQTree::getRootNode).filter(c -> c instanceof ConstructionNode).map(c -> (ConstructionNode)c).map(this::extractNullVariables).flatMap(Collection::stream).collect(ImmutableCollectors.toSet());
        if (nullVariables.isEmpty()) {
            return updatedChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, updatedChildren);
        }
        ImmutableMap<Variable, ImmutableFunctionalTerm> typedNullMap = this.extractTypedNullMap(tree, (ImmutableSet<Variable>)nullVariables);
        ImmutableList newChildren = (ImmutableList)updatedChildren.stream().map(c -> this.updateSubQuery((IQTree)c, typedNullMap)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
    }

    private ImmutableMap<Variable, ImmutableFunctionalTerm> extractTypedNullMap(IQTree tree, ImmutableSet<Variable> nullVariables) {
        ImmutableMap typeMap = (ImmutableMap)nullVariables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> this.uniqueTermTypeExtractor.extractSingleTermType((ImmutableTerm)v, tree)));
        return (ImmutableMap)typeMap.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).filter(e -> ((Optional)e.getValue()).filter(t -> t instanceof DBTermType).isPresent()).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.termFactory.getTypedNull((DBTermType)((Optional)e.getValue()).get())));
    }
}

