/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.iq.type.impl.AbstractExpressionTransformer;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBAndFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsNullOrNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBOrFunctionSymbol;
import it.unibz.inf.ontop.model.term.impl.NonGroundExpressionImpl;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SplitIsNullOverConjunctionDisjunctionNormalizer
extends DefaultRecursiveIQTreeVisitingTransformer
implements DialectExtraNormalizer {
    private final IQTreeTransformer expressionTransformer;

    @Inject
    protected SplitIsNullOverConjunctionDisjunctionNormalizer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
        super(iqFactory);
        this.expressionTransformer = new ExpressionTransformer(iqFactory, typeExtractor, termFactory);
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.expressionTransformer.transform(tree);
    }

    protected static class ExpressionTransformer
    extends AbstractExpressionTransformer {
        protected ExpressionTransformer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
            super(iqFactory, typeExtractor, termFactory);
        }

        protected boolean isFunctionSymbolToReplace(FunctionSymbol functionSymbol) {
            return functionSymbol instanceof DBIsNullOrNotFunctionSymbol;
        }

        protected ImmutableFunctionalTerm replaceFunctionSymbol(FunctionSymbol functionSymbol, ImmutableList<ImmutableTerm> newTerms, IQTree tree) {
            ImmutableTerm subTerm = (ImmutableTerm)newTerms.get(0);
            DBIsNullOrNotFunctionSymbol isNullOrNotFunctionSymbol = (DBIsNullOrNotFunctionSymbol)functionSymbol;
            if (!(subTerm instanceof NonGroundExpressionImpl)) {
                return this.termFactory.getImmutableFunctionalTerm(functionSymbol, newTerms);
            }
            NonGroundExpressionImpl subTermNonGroundExpression = (NonGroundExpressionImpl)subTerm;
            BooleanFunctionSymbol subTermFunctionSymbol = subTermNonGroundExpression.getFunctionSymbol();
            if (subTermFunctionSymbol == null || !(subTermFunctionSymbol instanceof DBOrFunctionSymbol) && !(subTermFunctionSymbol instanceof DBAndFunctionSymbol)) {
                return this.termFactory.getImmutableFunctionalTerm(functionSymbol, newTerms);
            }
            DBConstant whenNotNullTerm = this.termFactory.getDBBooleanConstant(!isNullOrNotFunctionSymbol.isTrueWhenNull());
            DBConstant whenNullTerm = this.termFactory.getDBBooleanConstant(isNullOrNotFunctionSymbol.isTrueWhenNull());
            ImmutableFunctionalTerm newFunctionSymbol = this.termFactory.getDBCase(Stream.of(Maps.immutableEntry((Object)subTermNonGroundExpression, (Object)whenNotNullTerm), Maps.immutableEntry((Object)this.termFactory.getDBNot((ImmutableExpression)subTermNonGroundExpression), (Object)whenNotNullTerm)), (ImmutableTerm)whenNullTerm, false);
            return newFunctionSymbol;
        }
    }
}

