/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.generation.normalization.impl.ProjectOrderByTermsNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeExtendedTransformer;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;

public class PushProjectedOrderByTermsNormalizer
extends DefaultRecursiveIQTreeExtendedTransformer<VariableGenerator>
implements DialectExtraNormalizer {
    private IntermediateQueryFactory iqFactory;
    private boolean onlyDistinct;

    protected PushProjectedOrderByTermsNormalizer(boolean onlyDistinct, IntermediateQueryFactory iqFactory, CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.iqFactory = iqFactory;
        this.onlyDistinct = onlyDistinct;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return tree.acceptTransformer((IQTreeExtendedTransformer)this, (Object)variableGenerator);
    }

    public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child, VariableGenerator variableGenerator) {
        ProjectOrderByTermsNormalizer.Decomposition decomposition = ProjectOrderByTermsNormalizer.Decomposition.decomposeTree(tree);
        if (decomposition.constructionNode.isEmpty() || decomposition.distinctNode.isEmpty() || decomposition.orderByNode.isEmpty()) {
            IQTree newDescendantTree = this.transform(decomposition.descendantTree, variableGenerator);
            return decomposition.descendantTree.equals(newDescendantTree) ? tree : decomposition.rebuildWithNewDescendantTree(newDescendantTree, this.iqFactory);
        }
        return this.normalizeWithDistinct(decomposition, variableGenerator);
    }

    public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child, VariableGenerator variableGenerator) {
        if (this.onlyDistinct) {
            return super.transformConstruction(tree, rootNode, child, (Object)variableGenerator);
        }
        ProjectOrderByTermsNormalizer.Decomposition decomposition = ProjectOrderByTermsNormalizer.Decomposition.decomposeTree(tree);
        if (decomposition.constructionNode.isEmpty() || decomposition.orderByNode.isEmpty()) {
            IQTree newDescendantTree = this.transform(decomposition.descendantTree, variableGenerator);
            return decomposition.descendantTree.equals(newDescendantTree) ? tree : decomposition.rebuildWithNewDescendantTree(newDescendantTree, this.iqFactory);
        }
        return this.normalize(decomposition, variableGenerator);
    }

    protected IQTree normalizeWithDistinct(ProjectOrderByTermsNormalizer.Decomposition decomposition, VariableGenerator context) {
        DistinctNode distinct = decomposition.distinctNode.get();
        UnaryIQTree newFullTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)distinct, this.normalize(decomposition, context));
        return newFullTree;
    }

    protected IQTree normalize(ProjectOrderByTermsNormalizer.Decomposition decomposition, VariableGenerator context) {
        ConstructionNode construct = decomposition.constructionNode.get();
        OrderByNode orderBy = decomposition.orderByNode.get();
        IQTree remainingSubtree = this.transform(decomposition.descendantTree, context);
        Substitution substitution = construct.getSubstitution();
        ImmutableSet orderByTerms = (ImmutableSet)orderBy.getComparators().stream().map(OrderByNode.OrderComparator::getTerm).collect(ImmutableCollectors.toSet());
        ImmutableMap definedInConstruct = (ImmutableMap)orderByTerms.stream().filter(term -> substitution.getRangeSet().contains(term)).collect(ImmutableCollectors.toMap(term -> term, term -> (NonGroundTerm)substitution.getDomain().stream().filter(t -> substitution.get(t).equals(term)).findFirst().orElseThrow(() -> new MinorOntopInternalBugException("Was expecting a definition with value " + term))));
        OrderByNode newOrderBy = this.iqFactory.createOrderByNode((ImmutableList)orderBy.getComparators().stream().map(comp -> this.iqFactory.createOrderComparator((NonGroundTerm)definedInConstruct.getOrDefault((Object)comp.getTerm(), (Object)comp.getTerm()), comp.isAscending())).collect(ImmutableCollectors.toList()));
        UnaryIQTree newOrderBySubtree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)construct, remainingSubtree);
        UnaryIQTree newFullTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newOrderBy, (IQTree)newOrderBySubtree);
        return newFullTree;
    }
}

