/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeExtendedTransformer;
import it.unibz.inf.ontop.utils.VariableGenerator;
import javax.inject.Inject;

public class EliminateLimitsFromSubQueriesNormalizer
extends DefaultRecursiveIQTreeExtendedTransformer<VariableGenerator>
implements DialectExtraNormalizer {
    private CoreSingletons coreSingletons;

    @Inject
    protected EliminateLimitsFromSubQueriesNormalizer(CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.coreSingletons = coreSingletons;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return tree.acceptTransformer((IQTreeExtendedTransformer)this, (Object)variableGenerator);
    }

    public IQTree transformSlice(IQTree tree, SliceNode sliceNode, IQTree child, VariableGenerator context) {
        if (sliceNode.getOffset() != 0L || sliceNode.getLimit().isEmpty()) {
            return super.transformSlice(tree, sliceNode, child, (Object)context);
        }
        SubLimitTransformer subLimitTransformer = new SubLimitTransformer((Long)sliceNode.getLimit().get(), this, this.coreSingletons);
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)sliceNode, subLimitTransformer.transform(child, context));
    }

    private static class SubLimitTransformer
    extends DefaultRecursiveIQTreeExtendedTransformer<VariableGenerator> {
        private final EliminateLimitsFromSubQueriesNormalizer eliminateLimitsFromSubQueriesNormalizer;
        private final long currentBounds;

        protected SubLimitTransformer(long currentBounds, EliminateLimitsFromSubQueriesNormalizer eliminateLimitsFromSubQueriesNormalizer, CoreSingletons coreSingletons) {
            super(coreSingletons);
            this.eliminateLimitsFromSubQueriesNormalizer = eliminateLimitsFromSubQueriesNormalizer;
            this.currentBounds = currentBounds;
        }

        public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
            return tree.acceptTransformer((IQTreeExtendedTransformer)this, (Object)variableGenerator);
        }

        public IQTree transformSlice(IQTree tree, SliceNode sliceNode, IQTree child, VariableGenerator context) {
            if (sliceNode.getOffset() != 0L || sliceNode.getLimit().isEmpty() || (Long)sliceNode.getLimit().get() < this.currentBounds) {
                return this.eliminateLimitsFromSubQueriesNormalizer.transform(tree, context);
            }
            return this.transform((IQTree)tree.getChildren().get(0), context);
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild, VariableGenerator context) {
            IQTree leftSubTree = this.transform((IQTree)tree.getChildren().get(0), context);
            IQTree rightSubTree = this.eliminateLimitsFromSubQueriesNormalizer.transform((IQTree)tree.getChildren().get(1), context);
            if (leftSubTree.equals(tree.getChildren().get(0)) && rightSubTree.equals(tree.getChildren().get(1))) {
                return tree;
            }
            return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)((LeftJoinNode)tree.getRootNode()), leftSubTree, rightSubTree);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children, VariableGenerator context) {
            return super.transformNaryCommutativeNode(tree, (NaryOperatorNode)rootNode, children, (Object)context);
        }

        public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children, VariableGenerator context) {
            return super.transformNaryCommutativeNode(tree, (NaryOperatorNode)rootNode, children, (Object)context);
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child, VariableGenerator context) {
            return super.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, (Object)context);
        }

        protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child, VariableGenerator context) {
            return this.eliminateLimitsFromSubQueriesNormalizer.transform(tree, context);
        }

        protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild, VariableGenerator context) {
            return this.eliminateLimitsFromSubQueriesNormalizer.transform(tree, context);
        }

        protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children, VariableGenerator context) {
            return this.eliminateLimitsFromSubQueriesNormalizer.transform(tree, context);
        }
    }
}

