/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.iq.type.impl.AbstractExpressionTransformer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractDBNonStrictEqOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public class AvoidEqualsBoolNormalizer
extends DefaultRecursiveIQTreeExtendedTransformer<VariableGenerator>
implements DialectExtraNormalizer {
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SingleTermTypeExtractor typeExtractor;

    @Inject
    protected AvoidEqualsBoolNormalizer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory, CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.typeExtractor = typeExtractor;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return new AvoidEqualsBoolExpressionTransformer(this.iqFactory, this.typeExtractor, this.termFactory).transform(tree);
    }

    private static class AvoidEqualsBoolExpressionTransformer
    extends AbstractExpressionTransformer {
        protected AvoidEqualsBoolExpressionTransformer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
            super(iqFactory, typeExtractor, termFactory);
        }

        protected boolean isFunctionSymbolToReplace(FunctionSymbol functionSymbol) {
            return functionSymbol instanceof AbstractDBNonStrictEqOperator || functionSymbol instanceof DefaultDBStrictEqFunctionSymbol;
        }

        protected ImmutableFunctionalTerm replaceFunctionSymbol(FunctionSymbol functionSymbol, ImmutableList<ImmutableTerm> newTerms, IQTree tree) {
            if (newTerms.size() != 2) {
                return this.noReplace(functionSymbol, newTerms);
            }
            Optional<ImmutableExpression> otherTerm = newTerms.stream().filter(t -> t instanceof ImmutableExpression).map(t -> (ImmutableExpression)t).findFirst();
            Optional<Constant> constantTerm = newTerms.stream().filter(t -> t instanceof Constant).map(t -> (Constant)t).filter(t -> t.equals(this.termFactory.getDBBooleanConstant(true)) || t.equals(this.termFactory.getDBBooleanConstant(false))).findFirst();
            if (otherTerm.isEmpty() || constantTerm.isEmpty()) {
                return this.noReplace(functionSymbol, newTerms);
            }
            boolean requiresTrue = constantTerm.get().equals(this.termFactory.getDBBooleanConstant(true));
            if (requiresTrue) {
                return (ImmutableFunctionalTerm)otherTerm.get();
            }
            return otherTerm.get().negate(this.termFactory);
        }

        private ImmutableFunctionalTerm noReplace(FunctionSymbol functionSymbol, ImmutableList<ImmutableTerm> newTerms) {
            return this.termFactory.getImmutableExpression((BooleanFunctionSymbol)functionSymbol, newTerms);
        }
    }
}

