/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.algebra.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.generation.algebra.SQLExpression;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SQLRelationVisitor;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Optional;

public class SQLFlattenExpressionImpl
implements SQLFlattenExpression {
    private final SQLExpression subExpression;
    private final Variable flattenedVar;
    private final Variable outputVar;
    private final Optional<Variable> indexVar;
    private final DBTermType flattenedType;

    @AssistedInject
    private SQLFlattenExpressionImpl(@Assisted SQLExpression subExpression, @Assisted(value="flattenedVar") Variable flattenedVar, @Assisted(value="outputVar") Variable outputVar, @Assisted Optional<Variable> indexVar, @Assisted DBTermType flattenedType) {
        this.subExpression = subExpression;
        this.flattenedVar = flattenedVar;
        this.outputVar = outputVar;
        this.indexVar = indexVar;
        this.flattenedType = flattenedType;
    }

    @Override
    public SQLExpression getSubExpression() {
        return this.subExpression;
    }

    @Override
    public <T> T acceptVisitor(SQLRelationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Variable getFlattenedVar() {
        return this.flattenedVar;
    }

    @Override
    public Variable getOutputVar() {
        return this.outputVar;
    }

    @Override
    public Optional<Variable> getIndexVar() {
        return this.indexVar;
    }

    @Override
    public DBTermType getFlattenedType() {
        return this.flattenedType;
    }
}

