/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.LensImpl;
import it.unibz.inf.ontop.dbschema.impl.json.FunctionalDependencyConstruct;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(as=JsonUnionLens.class)
public class JsonUnionLens
extends JsonLens {
    public final @Nonnull List<List<String>> unionRelations;
    public final @Nonnull String provenanceColumn;
    public final boolean makeDistinct;
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonUnionLens.class);

    @JsonCreator
    public JsonUnionLens(@JsonProperty(value="name") List<String> name, @JsonProperty(value="unionRelations", required=true) List<List<String>> unionRelations, @JsonProperty(value="provenanceColumn") String provenanceColumn, @JsonProperty(value="makeDistinct") boolean makeDistinct, @JsonProperty(value="uniqueConstraints") JsonLens.UniqueConstraints uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") JsonLens.OtherFunctionalDependencies otherFunctionalDependencies, @JsonProperty(value="foreignKeys") JsonLens.ForeignKeys foreignKeys, @JsonProperty(value="nonNullConstraints") JsonLens.NonNullConstraints nonNullConstraints, @JsonProperty(value="iriSafeConstraints") JsonLens.IRISafeConstraints iriSafeConstraints) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints, iriSafeConstraints);
        this.unionRelations = unionRelations;
        this.provenanceColumn = provenanceColumn;
        this.makeDistinct = makeDistinct;
    }

    @Override
    public Lens createViewDefinition(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        RelationID relationId = quotedIDFactory.createRelationID(this.name.toArray(new String[0]));
        IQ iq = this.createIQ(relationId, dbParameters, parentCacheMetadataLookup);
        int maxParentLevel = this.extractMaxParentLevel(iq, dbParameters.getCoreSingletons());
        RelationDefinition.AttributeListBuilder attributeBuilder = this.createAttributeBuilder(iq, dbParameters);
        return new LensImpl(ImmutableList.of((Object)relationId), attributeBuilder, iq, maxParentLevel + 1, dbParameters.getCoreSingletons());
    }

    private int extractMaxParentLevel(IQ iq, CoreSingletons coreSingletons) {
        LevelExtractor transformer = new LevelExtractor(coreSingletons);
        transformer.transform(iq.getTree());
        return transformer.getMaxLevel();
    }

    @Override
    public void insertIntegrityConstraints(Lens relation, ImmutableList<NamedRelationDefinition> baseRelations, MetadataLookup metadataLookupForFK, DBParameters dbParameters) throws MetadataExtractionException {
        QuotedIDFactory idFactory = metadataLookupForFK.getQuotedIDFactory();
        this.insertUniqueConstraints(relation, idFactory, this.uniqueConstraints == null ? List.of() : this.uniqueConstraints.added);
        this.insertFunctionalDependencies((NamedRelationDefinition)relation, idFactory, this.otherFunctionalDependencies == null ? List.of() : this.otherFunctionalDependencies.added, dbParameters.getCoreSingletons());
        if (this.foreignKeys != null) {
            this.insertForeignKeys((NamedRelationDefinition)relation, metadataLookupForFK, this.foreignKeys.added);
        }
    }

    @Override
    public ImmutableList<ImmutableList<Attribute>> getAttributesIncludingParentOnes(Lens lens, ImmutableList<Attribute> parentAttributes) {
        return ImmutableList.of();
    }

    protected ImmutableMap<String, Variable> extractProjectedVariables(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        VariableGenerator variableGenerator = dbParameters.getCoreSingletons().getCoreUtilsFactory().createVariableGenerator((Collection)ImmutableList.of());
        if (this.unionRelations.size() < 2) {
            throw new MetadataExtractionException("At least two relations are expected");
        }
        ImmutableList<NamedRelationDefinition> parents = this.getParentRelations(dbParameters, parentCacheMetadataLookup);
        NamedRelationDefinition firstParent = (NamedRelationDefinition)parents.get(0);
        if (parents.stream().skip(1L).anyMatch(parent -> !JsonUnionLens.areAllAttributesEqual(firstParent, parent))) {
            throw new MetadataExtractionException("The relations provided to the union do not have equal attributes");
        }
        ImmutableMap projectedVariables = (ImmutableMap)firstParent.getAttributes().stream().map(Attribute::getID).collect(ImmutableCollectors.toMap(QuotedID::getName, id -> variableGenerator.generateNewVariable(id.getName())));
        return projectedVariables;
    }

    private static boolean areAllAttributesEqual(NamedRelationDefinition a, NamedRelationDefinition b) {
        return a.getAttributes().stream().noneMatch(attributeA -> b.getAttributes().stream().noneMatch(attributeB -> JsonUnionLens.areAttributesEqual(attributeA, attributeB))) && b.getAttributes().stream().noneMatch(attributeB -> a.getAttributes().stream().noneMatch(attributeA -> JsonUnionLens.areAttributesEqual(attributeA, attributeB)));
    }

    private static boolean areAttributesEqual(Attribute a, Attribute b) {
        return a.getID().getName().equals(b.getID().getName()) && a.getTermType().equals(b.getTermType());
    }

    private ImmutableList<NamedRelationDefinition> getParentRelations(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) {
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        return (ImmutableList)this.unionRelations.stream().map(name -> {
            try {
                return parentCacheMetadataLookup.getRelation(quotedIDFactory.createRelationID(name.toArray(new String[0])));
            }
            catch (MetadataExtractionException e) {
                throw new RuntimeException(e);
            }
        }).collect(ImmutableCollectors.toList());
    }

    private IQ createIQ(RelationID relationId, DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        ImmutableSet allProjectedVariables;
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        TermFactory termFactory = coreSingletons.getTermFactory();
        IntermediateQueryFactory iqFactory = coreSingletons.getIQFactory();
        AtomFactory atomFactory = coreSingletons.getAtomFactory();
        ImmutableMap<String, Variable> projectedVariablesMap = this.extractProjectedVariables(dbParameters, parentCacheMetadataLookup);
        ImmutableSet projectedVariables = ImmutableSet.copyOf((Collection)projectedVariablesMap.values());
        if (this.includesProvenanceColumn()) {
            Variable provenanceVariable = termFactory.getVariable(this.getProvenanceColumn(quotedIDFactory));
            if (projectedVariables.contains((Object)provenanceVariable)) {
                throw new MetadataExtractionException("The provenance column with the name " + provenanceVariable.getName() + " cannot be added, because a column with this name already exists.");
            }
            allProjectedVariables = Sets.union((Set)projectedVariables, (Set)ImmutableSet.of((Object)provenanceVariable)).immutableCopy();
        } else {
            allProjectedVariables = projectedVariables;
        }
        ImmutableList children = (ImmutableList)this.getParentRelations(dbParameters, parentCacheMetadataLookup).stream().map(child -> iqFactory.createExtensionalDataNode((RelationDefinition)child, (ImmutableMap)IntStream.range(0, projectedVariablesMap.size()).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> (Variable)projectedVariablesMap.get((Object)child.getAttribute(i + 1).getID().getName()))))).collect(ImmutableCollectors.toList());
        ImmutableList extendedChildren = this.includesProvenanceColumn() ? (ImmutableList)children.stream().map(child -> this.addConstantColumn(termFactory.getVariable(this.getProvenanceColumn(quotedIDFactory)), quotedIDFactory.createRelationID(this.unionRelations.get(children.indexOf(child)).toArray(new String[0])).getComponents().reverse().stream().map(QuotedID::getName).collect(Collectors.joining(".")), (IQTree)child, coreSingletons)).collect(ImmutableCollectors.toList()) : children;
        UnionNode union = iqFactory.createUnionNode(allProjectedVariables);
        NaryIQTree iqTree = iqFactory.createNaryIQTree((NaryOperatorNode)union, extendedChildren);
        if (this.makeDistinct) {
            iqTree = iqFactory.createUnaryIQTree((UnaryOperatorNode)iqFactory.createDistinctNode(), (IQTree)iqTree);
        }
        NotYetTypedEqualityTransformer notYetTypedEqualityTransformer = coreSingletons.getNotYetTypedEqualityTransformer();
        IQTree transformedTree = notYetTypedEqualityTransformer.transform((IQTree)iqTree);
        IQTree finalTree = this.addIRISafeConstraints(transformedTree, dbParameters);
        AtomPredicate tmpPredicate = this.createTemporaryPredicate(relationId, allProjectedVariables.size(), coreSingletons);
        DistinctVariableOnlyDataAtom projectionAtom = atomFactory.getDistinctVariableOnlyDataAtom(tmpPredicate, ImmutableList.copyOf((Collection)allProjectedVariables));
        return iqFactory.createIQ(projectionAtom, finalTree);
    }

    private IQTree addConstantColumn(Variable variable, String value, IQTree child, CoreSingletons coreSingletons) {
        SubstitutionFactory substitutionFactory = coreSingletons.getSubstitutionFactory();
        IntermediateQueryFactory iqFactory = coreSingletons.getIQFactory();
        ConstructionSubstitutionNormalizer substitutionNormalizer = coreSingletons.getConstructionSubstitutionNormalizer();
        TermFactory termFactory = coreSingletons.getTermFactory();
        DBConstant provenanceValue = termFactory.getDBStringConstant(value);
        Substitution substitution = substitutionFactory.getSubstitution(variable, (ImmutableTerm)provenanceValue);
        ImmutableSet allProjectedVariables = Sets.union((Set)child.getKnownVariables(), (Set)ImmutableSet.of((Object)variable)).immutableCopy();
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = substitutionNormalizer.normalizeSubstitution(substitution, allProjectedVariables);
        ConstructionNode constructionNode = (ConstructionNode)normalization.generateTopConstructionNode().get();
        return iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, child);
    }

    private AtomPredicate createTemporaryPredicate(RelationID relationId, int arity, CoreSingletons coreSingletons) {
        DBTermType dbRootType = coreSingletons.getTypeFactory().getDBTypeFactory().getAbstractRootDBType();
        return new JsonLens.TemporaryLensPredicate(relationId.getSQLRendering(), (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).mapToObj(i -> dbRootType).collect(ImmutableCollectors.toList())));
    }

    protected void insertUniqueConstraints(Lens relation, QuotedIDFactory idFactory, List<JsonLens.AddUniqueConstraints> addUniqueConstraints) throws MetadataExtractionException {
        List allAddUniqueConstraints = Stream.concat(addUniqueConstraints.stream(), this.inferUniqueConstraints(relation).stream()).collect(Collectors.toList());
        for (JsonLens.AddUniqueConstraints addUC : allAddUniqueConstraints) {
            if (addUC.isPrimaryKey != null && addUC.isPrimaryKey.booleanValue()) {
                LOGGER.warn("Primary key set in the view file for " + addUC.name);
            }
            FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)addUC.name);
            JsonMetadata.deserializeAttributeList(idFactory, addUC.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
            builder.build();
        }
    }

    private ImmutableList<JsonLens.AddUniqueConstraints> inferUniqueConstraints(Lens relation) {
        IQTree iqTree = relation.getIQ().normalizeForOptimization().getTree();
        ImmutableSet constraints = iqTree.inferUniqueConstraints();
        DistinctVariableOnlyDataAtom projectedAtom = relation.getIQ().getProjectionAtom();
        ImmutableMap variableIds = (ImmutableMap)relation.getAttributes().stream().collect(ImmutableCollectors.toMap(a -> projectedAtom.getTerm(a.getIndex() - 1), Attribute::getID));
        return (ImmutableList)constraints.stream().map(vs -> new JsonLens.AddUniqueConstraints(UUID.randomUUID().toString(), (List)vs.stream().map(v -> Optional.ofNullable((QuotedID)variableIds.get(v)).orElseThrow(() -> new MinorOntopInternalBugException("The variables of the unique constraints should be projected"))).map(QuotedID::getSQLRendering).collect(ImmutableCollectors.toList()), false)).collect(ImmutableCollectors.toList());
    }

    private void insertFunctionalDependencies(NamedRelationDefinition relation, QuotedIDFactory idFactory, List<JsonLens.AddFunctionalDependency> addFunctionalDependencies, CoreSingletons coreSingletons) throws MetadataExtractionException {
        try {
            this.insertTransitiveFunctionalDependencies((ImmutableSet<FunctionalDependencyConstruct>)((ImmutableSet)addFunctionalDependencies.stream().map(jsonFD -> new FunctionalDependencyConstruct((ImmutableSet<QuotedID>)((ImmutableSet)jsonFD.determinants.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet())), (ImmutableSet<QuotedID>)((ImmutableSet)jsonFD.dependents.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet())))).collect(ImmutableCollectors.toSet())), relation, coreSingletons);
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException(String.format("Cannot find attribute %s for Functional Dependency.", e.getAttributeID()));
        }
    }

    private void insertForeignKeys(NamedRelationDefinition relation, MetadataLookup lookup, List<JsonLens.AddForeignKey> addForeignKeys) throws MetadataExtractionException {
        for (JsonLens.AddForeignKey fk : addForeignKeys) {
            this.insertForeignKey(relation, lookup, fk);
        }
    }

    protected void insertForeignKey(NamedRelationDefinition relation, MetadataLookup lookup, JsonLens.AddForeignKey addForeignKey) throws MetadataExtractionException {
        NamedRelationDefinition targetRelation;
        QuotedIDFactory idFactory = lookup.getQuotedIDFactory();
        RelationID targetRelationId = JsonMetadata.deserializeRelationID(idFactory, addForeignKey.to.relation);
        try {
            targetRelation = lookup.getRelation(targetRelationId);
        }
        catch (MetadataExtractionException e) {
            LOGGER.info("Cannot find relation {} for FK {}", (Object)targetRelationId, (Object)addForeignKey.name);
            return;
        }
        int columnCount = addForeignKey.to.columns.size();
        if (addForeignKey.from.size() != columnCount) {
            throw new MetadataExtractionException("Not the same number of from and to columns in FK definition");
        }
        try {
            ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((String)addForeignKey.name, (NamedRelationDefinition)relation, (NamedRelationDefinition)targetRelation);
            for (int i = 0; i < columnCount; ++i) {
                builder.add(idFactory.createAttributeID(addForeignKey.from.get(i)), idFactory.createAttributeID(addForeignKey.to.columns.get(i)));
            }
            builder.build();
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException((Exception)((Object)e));
        }
    }

    private boolean includesProvenanceColumn() {
        return this.provenanceColumn != null && !this.provenanceColumn.isEmpty();
    }

    private String getProvenanceColumn(QuotedIDFactory quotedIDFactory) {
        return quotedIDFactory.createAttributeID(this.provenanceColumn).getName();
    }

    private static class LevelExtractor
    extends DefaultRecursiveIQTreeVisitingTransformer {
        int maxLevel = 0;

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public LevelExtractor(CoreSingletons coreSingletons) {
            super(coreSingletons);
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dataNode) {
            RelationDefinition parentRelation = dataNode.getRelationDefinition();
            int level = parentRelation instanceof Lens ? ((Lens)parentRelation).getLevel() : 0;
            this.maxLevel = Math.max(this.maxLevel, level);
            return dataNode;
        }
    }
}

