/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.JsonBasicOrJoinLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import java.util.List;
import javax.annotation.Nonnull;

@JsonDeserialize(as=JsonJoinLens.class)
public class JsonJoinLens
extends JsonBasicOrJoinLens {
    public final @Nonnull JoinPart joinPart;

    protected JsonJoinLens(@JsonProperty(value="columns") JsonBasicOrJoinLens.Columns columns, @JsonProperty(value="name") List<String> name, @JsonProperty(value="join") JoinPart joinPart, @JsonProperty(value="filterExpression") String filterExpression, @JsonProperty(value="uniqueConstraints") JsonLens.UniqueConstraints uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") JsonLens.OtherFunctionalDependencies otherFunctionalDependencies, @JsonProperty(value="foreignKeys") JsonLens.ForeignKeys foreignKeys, @JsonProperty(value="nonNullConstraints") JsonLens.NonNullConstraints nonNullConstraints, @JsonProperty(value="iriSafeConstraints") JsonLens.IRISafeConstraints iriSafeConstraints) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints, iriSafeConstraints, columns, filterExpression);
        this.joinPart = joinPart;
    }

    @Override
    protected ImmutableList<JsonBasicOrJoinLens.ParentDefinition> extractParentDefinitions(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        if (this.joinPart.columnPrefixes.size() != this.joinPart.relations.size()) {
            throw new MetadataExtractionException("Exactly one column prefix must be defined per parent relation");
        }
        if (this.joinPart.relations.size() < 2) {
            throw new MetadataExtractionException("At least two relations are expected");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.joinPart.relations.size(); ++i) {
            NamedRelationDefinition parentDefinition = parentCacheMetadataLookup.getRelation(quotedIDFactory.createRelationID(this.joinPart.relations.get(i).toArray(new String[0])));
            builder.add((Object)new JsonBasicOrJoinLens.ParentDefinition(parentDefinition, this.joinPart.columnPrefixes.get(i)));
        }
        return builder.build();
    }

    @Override
    public ImmutableList<ImmutableList<Attribute>> getAttributesIncludingParentOnes(Lens lens, ImmutableList<Attribute> parentAttributes) {
        return ImmutableList.of();
    }

    protected static class JoinPart
    extends JsonOpenObject {
        public final List<List<String>> relations;
        public final List<String> columnPrefixes;

        @JsonCreator
        public JoinPart(@JsonProperty(value="relations") List<List<String>> relations, @JsonProperty(value="columnPrefixes") List<String> columnPrefixes) {
            this.relations = relations;
            this.columnPrefixes = columnPrefixes;
        }
    }
}

