/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"determinants", "dependents"})
public class JsonFunctionalDependency
extends JsonOpenObject {
    public final List<String> determinants;
    public final List<String> dependents;

    @JsonCreator
    public JsonFunctionalDependency(@JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="dependents") List<String> dependents) {
        this.determinants = determinants;
        this.dependents = dependents;
    }

    public JsonFunctionalDependency(FunctionalDependency fd) {
        this.determinants = JsonMetadata.serializeAttributeList(fd.getDeterminants().stream());
        this.dependents = JsonMetadata.serializeAttributeList(fd.getDependents().stream());
    }

    public void insert(NamedRelationDefinition relation, QuotedIDFactory idFactory) throws MetadataExtractionException {
        FunctionalDependency.Builder builder = FunctionalDependency.defaultBuilder((NamedRelationDefinition)relation);
        JsonMetadata.deserializeAttributeList(idFactory, this.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
        JsonMetadata.deserializeAttributeList(idFactory, this.dependents, arg_0 -> ((FunctionalDependency.Builder)builder).addDependent(arg_0));
        builder.build();
    }
}

