/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.LensImpl;
import it.unibz.inf.ontop.dbschema.impl.json.FunctionalDependencyConstruct;
import it.unibz.inf.ontop.dbschema.impl.json.JsonBasicOrJoinOrNestedLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(as=JsonFlattenLens.class)
public class JsonFlattenLens
extends JsonBasicOrJoinOrNestedLens {
    public final @Nonnull Columns columns;
    public final @Nonnull List<String> baseRelation;
    private final @Nonnull FlattenedColumn flattenedColumn;
    public final JsonLens.UniqueConstraints uniqueConstraints;
    public final JsonLens.OtherFunctionalDependencies otherFunctionalDependencies;
    public final JsonLens.ForeignKeys foreignKeys;
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonFlattenLens.class);

    @JsonCreator
    public JsonFlattenLens(@JsonProperty(value="name") List<String> name, @JsonProperty(value="baseRelation") List<String> baseRelation, @JsonProperty(value="flattenedColumn") FlattenedColumn flattenedColumn, @JsonProperty(value="columns") Columns columns, @JsonProperty(value="uniqueConstraints") JsonLens.UniqueConstraints uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") JsonLens.OtherFunctionalDependencies otherFunctionalDependencies, @JsonProperty(value="foreignKeys") JsonLens.ForeignKeys foreignKeys, @JsonProperty(value="nonNullConstraints") JsonLens.NonNullConstraints nonNullConstraints, @JsonProperty(value="iriSafeConstraints") JsonLens.IRISafeConstraints iriSafeConstraints) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints, iriSafeConstraints);
        this.columns = columns;
        this.baseRelation = baseRelation;
        this.flattenedColumn = flattenedColumn;
        this.uniqueConstraints = uniqueConstraints;
        this.otherFunctionalDependencies = otherFunctionalDependencies;
        this.foreignKeys = foreignKeys;
    }

    @Override
    public Lens createViewDefinition(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        ViewDefinitionCreator creator = new ViewDefinitionCreator(dbParameters);
        NamedRelationDefinition parentDefinition = parentCacheMetadataLookup.getRelation(creator.getRelationID(this.baseRelation));
        int parentLevel = parentDefinition instanceof Lens ? ((Lens)parentDefinition).getLevel() : 0;
        RelationID relationId = creator.getRelationID(this.name);
        IQ iq = creator.createIQ(relationId, parentDefinition);
        RelationDefinition.AttributeListBuilder attributeBuilder = this.createAttributeBuilder(iq, dbParameters);
        return new LensImpl(ImmutableList.of((Object)relationId), attributeBuilder, iq, parentLevel + 1, dbParameters.getCoreSingletons());
    }

    @Override
    public void insertIntegrityConstraints(Lens relation, ImmutableList<NamedRelationDefinition> baseRelations, MetadataLookup metadataLookupForFK, DBParameters dbParameters) throws MetadataExtractionException {
        QuotedIDFactory idFactory = metadataLookupForFK.getQuotedIDFactory();
        CoreSingletons cs = dbParameters.getCoreSingletons();
        if (baseRelations.size() != 1) {
            throw new MetadataExtractionException("A nested view should have exactly one base relation");
        }
        NamedRelationDefinition baseRelation = (NamedRelationDefinition)baseRelations.get(0);
        this.insertUniqueConstraints(relation, idFactory, Optional.ofNullable(this.uniqueConstraints).map(u -> u.added).orElseGet(ImmutableList::of), (ImmutableList<NamedRelationDefinition>)ImmutableList.of(), cs);
        ImmutableSet addedColumns = (ImmutableSet)Stream.concat(Optional.ofNullable(this.columns.position).stream(), Stream.of(this.columns.newColumn)).map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        ImmutableSet keptColumns = (ImmutableSet)this.columns.kept.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        ImmutableSet hiddenColumns = (ImmutableSet)baseRelation.getAttributes().stream().map(Attribute::getID).filter(d -> !keptColumns.contains(d)).collect(ImmutableCollectors.toSet());
        this.insertFunctionalDependencies((NamedRelationDefinition)relation, idFactory, (ImmutableSet<QuotedID>)hiddenColumns, (ImmutableSet<QuotedID>)addedColumns, Optional.ofNullable(this.otherFunctionalDependencies).map(d -> d.added).orElseGet(ImmutableList::of), (List<FunctionalDependencyConstruct>)this.inferFDsFromParentUCs((ImmutableSet<QuotedID>)keptColumns, baseRelation), baseRelations, dbParameters.getCoreSingletons());
        this.insertForeignKeys(relation, metadataLookupForFK, (List)Stream.concat(Optional.ofNullable(this.foreignKeys).map(f -> f.added).orElseGet(ImmutableList::of).stream(), this.inferForeignKeysFromParentUCs((ImmutableSet<QuotedID>)keptColumns, baseRelation).stream()).collect(ImmutableCollectors.toList()), baseRelations);
    }

    private ImmutableList<JsonLens.AddForeignKey> inferForeignKeysFromParentUCs(ImmutableSet<QuotedID> keptColumns, NamedRelationDefinition baseRelation) {
        return (ImmutableList)baseRelation.getUniqueConstraints().stream().map(UniqueConstraint::getAttributes).map(attributes -> (ImmutableSet)attributes.stream().map(Attribute::getID).collect(ImmutableCollectors.toSet())).map(attributes -> this.getInferredForeignKey((ImmutableSet<QuotedID>)attributes, keptColumns)).flatMap(Optional::stream).collect(ImmutableCollectors.toList());
    }

    private Optional<JsonLens.AddForeignKey> getInferredForeignKey(ImmutableSet<QuotedID> ucs, ImmutableSet<QuotedID> keptColumns) {
        if (keptColumns.containsAll(ucs)) {
            return Optional.of(new JsonLens.AddForeignKey(UUID.randomUUID().toString(), (List)ucs.stream().map(QuotedID::getSQLRendering).collect(ImmutableCollectors.toList()), new JsonLens.ForeignKeyPart(this.baseRelation, (List)ucs.stream().map(QuotedID::getSQLRendering).collect(ImmutableCollectors.toList()))));
        }
        return Optional.empty();
    }

    private ImmutableList<FunctionalDependencyConstruct> inferFDsFromParentUCs(ImmutableSet<QuotedID> keptColumns, NamedRelationDefinition baseRelation) {
        return (ImmutableList)baseRelation.getUniqueConstraints().stream().map(UniqueConstraint::getAttributes).map(attributes -> (ImmutableSet)attributes.stream().map(Attribute::getID).collect(ImmutableCollectors.toSet())).map(attributes -> this.getInferredFD((ImmutableSet<QuotedID>)attributes, keptColumns)).flatMap(Optional::stream).collect(ImmutableCollectors.toList());
    }

    private Optional<FunctionalDependencyConstruct> getInferredFD(ImmutableSet<QuotedID> determinants, ImmutableSet<QuotedID> keptColumns) {
        ImmutableSet difference;
        if (keptColumns.containsAll(determinants) && !(difference = Sets.difference(keptColumns, determinants).immutableCopy()).isEmpty()) {
            return Optional.of(new FunctionalDependencyConstruct(determinants, (ImmutableSet<QuotedID>)difference));
        }
        return Optional.empty();
    }

    @Override
    public ImmutableList<ImmutableList<Attribute>> getAttributesIncludingParentOnes(Lens lens, ImmutableList<Attribute> parentAttributes) {
        return ImmutableList.of();
    }

    @JsonPropertyOrder(value={"name", "datatype"})
    private static class FlattenedColumn
    extends JsonOpenObject {
        public final @Nonnull String name;
        public final @Nonnull String datatype;

        @JsonCreator
        public FlattenedColumn(@JsonProperty(value="name") String name, @JsonProperty(value="datatype") String datatype) {
            this.name = name;
            this.datatype = datatype;
        }
    }

    @JsonPropertyOrder(value={"kept", "new", "position"})
    private static class Columns
    extends JsonOpenObject {
        public final @Nonnull List<String> kept;
        public final @Nonnull String newColumn;
        public final String position;

        @JsonCreator
        public Columns(@JsonProperty(value="kept") List<String> kept, @JsonProperty(value="new") String newColumn, @JsonProperty(value="position") String position) {
            this.kept = kept;
            this.newColumn = newColumn;
            this.position = position;
        }
    }

    private class ViewDefinitionCreator {
        final DBParameters dbParameters;
        final QuotedIDFactory quotedIDFactory;
        final IntermediateQueryFactory iqFactory;
        final CoreUtilsFactory coreUtilsFactory;
        final SubstitutionFactory substitutionFactory;
        final AtomFactory atomFactory;
        final TermFactory termFactory;
        final DBTypeFactory dbTypeFactory;
        final CoreSingletons coreSingletons;

        ViewDefinitionCreator(DBParameters dbParameters) {
            this.dbParameters = dbParameters;
            this.quotedIDFactory = dbParameters.getQuotedIDFactory();
            this.coreSingletons = dbParameters.getCoreSingletons();
            this.iqFactory = this.coreSingletons.getIQFactory();
            this.coreUtilsFactory = this.coreSingletons.getCoreUtilsFactory();
            this.substitutionFactory = this.coreSingletons.getSubstitutionFactory();
            this.atomFactory = this.coreSingletons.getAtomFactory();
            this.termFactory = this.coreSingletons.getTermFactory();
            this.dbTypeFactory = dbParameters.getDBTypeFactory();
        }

        RelationID getRelationID(List<String> components) {
            return this.quotedIDFactory.createRelationID(components.toArray(new String[0]));
        }

        IQ createIQ(RelationID relationId, NamedRelationDefinition parentDefinition) throws MetadataExtractionException {
            VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)ImmutableSet.of());
            ImmutableList attributes = parentDefinition.getAttributes();
            ImmutableMap parentAttributeMap = (ImmutableMap)IntStream.range(0, attributes.size()).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> ((Attribute)attributes.get(i.intValue())).getID().getName()));
            ImmutableMap parentVariableMap = (ImmutableMap)parentAttributeMap.values().stream().collect(ImmutableCollectors.toMap(s -> s, arg_0 -> ((VariableGenerator)variableGenerator).generateNewVariable(arg_0)));
            Optional<Variable> indexVariable = Optional.ofNullable(JsonFlattenLens.this.columns.position).map(p -> variableGenerator.generateNewVariable(JsonFlattenLens.this.normalizeAttributeName(JsonFlattenLens.this.columns.position, this.quotedIDFactory)));
            Variable flattenedVariable = Optional.ofNullable((Variable)parentVariableMap.get((Object)JsonFlattenLens.this.normalizeAttributeName(JsonFlattenLens.this.flattenedColumn.name, this.quotedIDFactory))).orElseThrow(() -> new MetadataExtractionException("The flattened column " + JsonFlattenLens.this.flattenedColumn.name + " is not present in the base relation"));
            DBTermType flattenedDBType = this.dbTypeFactory.getDBTermType(JsonFlattenLens.this.flattenedColumn.datatype);
            Variable flattenedIfArrayVariable = variableGenerator.generateNewVariableFromVar(flattenedVariable);
            Variable flattenOutputVariable = variableGenerator.generateNewVariable(JsonFlattenLens.this.normalizeAttributeName(JsonFlattenLens.this.columns.newColumn, this.quotedIDFactory));
            ImmutableSet<Variable> projectedVariables = this.computeRetainedVariables((ImmutableMap<String, Variable>)parentVariableMap, indexVariable, flattenOutputVariable);
            AtomPredicate tmpPredicate = JsonFlattenLens.this.createTemporaryPredicate(relationId, projectedVariables.size(), this.coreSingletons);
            DistinctVariableOnlyDataAtom projectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom(tmpPredicate, ImmutableList.copyOf(projectedVariables));
            ConstructionNode constructionNode = this.iqFactory.createConstructionNode(projectedVariables);
            FilterNode filterNode = this.iqFactory.createFilterNode(this.termFactory.getDBIsNotNull((ImmutableTerm)flattenOutputVariable));
            FlattenNode flattennode = this.iqFactory.createFlattenNode(flattenOutputVariable, flattenedDBType.getCategory() == DBTermType.Category.ARRAY ? flattenedVariable : flattenedIfArrayVariable, indexVariable, flattenedDBType);
            ExtensionalDataNode dataNode = this.iqFactory.createExtensionalDataNode((RelationDefinition)parentDefinition, this.compose((ImmutableMap<Integer, String>)parentAttributeMap, (ImmutableMap<String, Variable>)parentVariableMap));
            if (flattenedDBType.getCategory() == DBTermType.Category.ARRAY) {
                UnaryIQTree treeBeforeSafenessInfo = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)flattennode, (IQTree)dataNode));
                return this.iqFactory.createIQ(projectionAtom, JsonFlattenLens.this.addIRISafeConstraints((IQTree)treeBeforeSafenessInfo, this.dbParameters));
            }
            ConstructionNode checkArrayConstructionNode = this.iqFactory.createConstructionNode(Sets.union((Set)dataNode.getVariables(), (Set)ImmutableSet.of((Object)flattenedIfArrayVariable)).immutableCopy(), this.substitutionFactory.getSubstitution(flattenedIfArrayVariable, (ImmutableTerm)this.termFactory.getIfElseNull(this.termFactory.getDBIsArray(flattenedDBType, (ImmutableTerm)flattenedVariable), (ImmutableTerm)flattenedVariable)));
            UnaryIQTree treeBeforeSafenessInfo = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filterNode, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)flattennode, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)checkArrayConstructionNode, (IQTree)dataNode))));
            return this.iqFactory.createIQ(projectionAtom, JsonFlattenLens.this.addIRISafeConstraints((IQTree)treeBeforeSafenessInfo, this.dbParameters));
        }

        private ImmutableSet<Variable> computeRetainedVariables(ImmutableMap<String, Variable> parentVariableMap, Optional<Variable> positionVariable, Variable outputVariable) throws MetadataExtractionException {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String keptColumn : JsonFlattenLens.this.columns.kept) {
                String normalizedName = JsonFlattenLens.this.normalizeAttributeName(keptColumn, this.quotedIDFactory);
                Variable var = Optional.ofNullable((Variable)parentVariableMap.get((Object)normalizedName)).orElseThrow(() -> new MetadataExtractionException("Kept column " + normalizedName + " not found in base view definition"));
                builder.add((Object)var);
            }
            positionVariable.ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
            builder.add((Object)outputVariable);
            return builder.build();
        }

        private ImmutableMap<Integer, ? extends VariableOrGroundTerm> compose(ImmutableMap<Integer, String> map1, ImmutableMap<String, Variable> map2) {
            return (ImmutableMap)map1.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (Variable)map2.get(e.getValue())));
        }
    }
}

